<?php
// Debug script to test summary table API with heat_number parameter
require_once 'includes/db.php';

$event_id = 6;
$heat_number = 1;

echo "=== TESTING SUMMARY TABLE API ===\n\n";

// Check if we have participants in heat 1
$stmt = $pdo->prepare("SELECT COUNT(*) as count FROM event_participants WHERE event_id = ? AND heat_number = ?");
$stmt->execute([$event_id, $heat_number]);
$heat1_participants = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
echo "Participants in Event $event_id, Heat $heat_number: $heat1_participants\n";

// Check if we have scores
$stmt = $pdo->prepare("SELECT COUNT(*) as count FROM scoring_results WHERE event_id = ? AND heat_number = ?");
$stmt->execute([$event_id, $heat_number]);
$heat1_scores = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
echo "Scores in Event $event_id, Heat $heat_number: $heat1_scores\n";

// Check heat settings
$stmt = $pdo->prepare("SELECT runs_count FROM event_heat_settings WHERE event_id = ? AND heat_number = ?");
$stmt->execute([$event_id, $heat_number]);
$runs_count = $stmt->fetch(PDO::FETCH_ASSOC);
echo "Runs configured for Heat $heat_number: " . ($runs_count ? $runs_count['runs_count'] : 'NULL - will use event default') . "\n";

// Check event default
$stmt = $pdo->prepare("SELECT runs_per_heat FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event_runs = $stmt->fetch(PDO::FETCH_ASSOC)['runs_per_heat'];
echo "Event default runs_per_heat: $event_runs\n\n";

// Test the actual API call
echo "=== CALLING API ===\n";
$url = "http://localhost/v2/api/summary_table_api.php?event_id=$event_id&heat_number=$heat_number&category=all&format=json";
echo "URL: $url\n\n";

$response = file_get_contents($url);
$data = json_decode($response, true);

if ($data) {
    echo "API Response:\n";
    echo "Success: " . ($data['success'] ? 'true' : 'false') . "\n";
    if (isset($data['message'])) {
        echo "Message: " . $data['message'] . "\n";
    }
    if (isset($data['debug'])) {
        echo "Debug info:\n";
        print_r($data['debug']);
    }
    if (isset($data['participants_count'])) {
        echo "Participants found: " . $data['participants_count'] . "\n";
    }
    if (isset($data['heat_run_filter'])) {
        echo "Heat run filter: " . $data['heat_run_filter'] . "\n";
    }
} else {
    echo "ERROR: Could not decode API response\n";
    echo "Raw response: " . substr($response, 0, 500) . "\n";
}

echo "\n=== SAMPLE PARTICIPANT DATA ===\n";
$stmt = $pdo->prepare("
    SELECT p.id, p.bib_number, p.first_name, p.last_name, ep.heat_number, ep.category_id
    FROM participants p
    JOIN event_participants ep ON p.id = ep.participant_id
    WHERE ep.event_id = ? AND ep.heat_number = ?
    LIMIT 5
");
$stmt->execute([$event_id, $heat_number]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "BIB {$row['bib_number']}: {$row['first_name']} {$row['last_name']} (Category ID: {$row['category_id']})\n";
}

echo "\n=== SAMPLE SCORE DATA ===\n";
$stmt = $pdo->prepare("
    SELECT s.participant_id, p.bib_number, s.run_number, s.total_score, s.heat_number
    FROM scoring_results s
    JOIN participants p ON s.participant_id = p.id
    WHERE s.event_id = ? AND s.heat_number = ?
    LIMIT 5
");
$stmt->execute([$event_id, $heat_number]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "Participant ID {$row['participant_id']} (BIB {$row['bib_number']}): Run {$row['run_number']}, Score: {$row['total_score']}\n";
}
