<?php
require_once 'includes/db.php';

echo "<h2>Create Test Configuration for Event 3</h2>";

// Create a sample configuration that hides some components
$testConfig = [
    'cards' => [
        'criteriaInputGrid' => ['enabled' => true],
        'finalCalculatedScore' => ['enabled' => true], 
        'figuresCard' => ['enabled' => false], // Hide figures card
        'latestScores' => ['enabled' => true],
        'otherHeatScores' => ['enabled' => false], // Hide other scores
        'diversityValidation' => ['enabled' => false], // Hide diversity validation
        'figureHistory' => ['enabled' => false], // Hide figure history
        'formatInfo' => ['enabled' => false] // Hide format info
    ],
    'layout' => [
        'compactMode' => false,
        'hideEmptyCards' => true
    ]
];

try {
    // Insert test configuration
    $stmt = $pdo->prepare("INSERT INTO scoring_layout_configs (event_id, heat_number, configuration, created_at, updated_at) VALUES (?, ?, ?, NOW(), NOW()) ON DUPLICATE KEY UPDATE configuration = VALUES(configuration), updated_at = NOW()");
    
    $configJson = json_encode($testConfig);
    $stmt->execute([3, null, $configJson]); // null heat_number means applies to all heats
    
    echo "<p><strong>✅ Test configuration created for Event 3 (all heats)</strong></p>";
    echo "<p>Configuration hides: Figures Card, Other Heat Scores, Diversity Validation, Figure History, Format Info</p>";
    echo "<p>Configuration shows: Criteria Input Grid, Final Score Display, Latest Scores</p>";
    
    echo "<h3>Configuration JSON:</h3>";
    echo "<pre>" . htmlspecialchars($configJson) . "</pre>";
    
    echo "<h3>Test Links:</h3>";
    echo "<p><a href='judge/score.php?event_id=3&heat_number=1' target='_blank'>Test Judge Panel Event 3 Heat 1</a></p>";
    echo "<p><a href='test_event3_config.php' target='_blank'>Check Configuration Status</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>Error creating configuration: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>