<?php
require_once '../includes/db.php';

// Show PHP configuration
echo "<h2>PHP Configuration</h2>";
echo "FTP Extension: " . (extension_loaded('ftp') ? "✓ Loaded" : "✗ Not loaded") . "<br>";
echo "JSON Extension: " . (extension_loaded('json') ? "✓ Loaded" : "✗ Not loaded") . "<br>";
echo "Error reporting: " . error_reporting() . "<br>";
echo "Display errors: " . ini_get('display_errors') . "<br>";
echo "Log errors: " . ini_get('log_errors') . "<br>";
echo "Error log: " . ini_get('error_log') . "<br>";

// Test server 3 configuration
echo "<h2>Server 3 Configuration</h2>";
$stmt = $pdo->prepare("SELECT * FROM publish_servers WHERE id = 3");
$stmt->execute();
$server = $stmt->fetch();

if ($server) {
    echo "<pre>";
    foreach ($server as $key => $value) {
        echo "$key: " . htmlspecialchars($value) . "\n";
    }
    echo "</pre>";
    
    // Test FTP connection
    echo "<h3>Testing FTP Connection</h3>";
    
    $ftp = ftp_connect($server['ftp_host'], $server['ftp_port'] ?: 21);
    if ($ftp) {
        echo "✓ FTP connection established<br>";
        
        if (ftp_login($ftp, $server['ftp_username'], $server['ftp_password'])) {
            echo "✓ FTP login successful<br>";
            
            // Try to change to directory
            if ($server['ftp_directory'] && ftp_chdir($ftp, $server['ftp_directory'])) {
                echo "✓ Changed to directory: " . $server['ftp_directory'] . "<br>";
            } else if ($server['ftp_directory']) {
                echo "✗ Failed to change to directory: " . $server['ftp_directory'] . "<br>";
            }
            
            // List current directory
            $files = ftp_nlist($ftp, '.');
            if ($files) {
                echo "Current directory contents:<br>";
                foreach ($files as $file) {
                    echo "- $file<br>";
                }
            } else {
                echo "No files in current directory or listing failed<br>";
            }
            
        } else {
            echo "✗ FTP login failed<br>";
        }
        
        ftp_close($ftp);
    } else {
        echo "✗ FTP connection failed<br>";
    }
    
} else {
    echo "Server not found!";
}

// Test temp directory
echo "<h2>Temp Directory Test</h2>";
$temp_dir = sys_get_temp_dir();
echo "System temp dir: $temp_dir<br>";
echo "Writable: " . (is_writable($temp_dir) ? "✓ Yes" : "✗ No") . "<br>";

$test_dir = $temp_dir . '/stylescore_test';
if (!is_dir($test_dir)) {
    mkdir($test_dir, 0777, true);
}
echo "Test directory: $test_dir<br>";
echo "Test dir exists: " . (is_dir($test_dir) ? "✓ Yes" : "✗ No") . "<br>";
echo "Test dir writable: " . (is_writable($test_dir) ? "✓ Yes" : "✗ No") . "<br>";

// Test file creation
$test_file = $test_dir . '/test.txt';
$result = file_put_contents($test_file, "Test content");
echo "File creation test: " . ($result !== false ? "✓ Success ($result bytes)" : "✗ Failed") . "<br>";

if (file_exists($test_file)) {
    unlink($test_file);
    echo "Test file cleanup: ✓ Done<br>";
}
?>
