<?php
// Simple PHP test for the Reports API
$event_id = $_GET['event_id'] ?? 1;
$filter_type = $_GET['type'] ?? 'all';

// Test the API by including it directly
$_GET['event_id'] = $event_id;
$_GET['type'] = $filter_type;
$_GET['format'] = 'array';

// Capture the API response
ob_start();
$api_response = include '../api/reports_api.php';
$output = ob_get_clean();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports API Test - PHP Version</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .json-output {
            background: #2d3748;
            color: #e2e8f0;
            font-family: 'Consolas', 'Monaco', monospace;
            font-size: 13px;
            line-height: 1.5;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container-fluid container-StyleScore p-4">
        <div class="row">
            <div class="col-12">
                <div class="border-0 shadow-none card">
                    <div class="border-0 shadow-none card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-vial me-2"></i>Reports API Test - PHP Version
                        </h5>
                    </div>
                    <div class="border-0 shadow-none card-body">
                        <form method="GET" class="mb-4">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <label for="event_id" class="form-label">Event ID:</label>
                                    <input type="number" class="form-control" id="event_id" name="event_id" value="<?= htmlspecialchars($event_id) ?>" placeholder="Enter event ID">
                                </div>
                                
                                <div class="col-md-4">
                                    <label for="type" class="form-label">Filter Type:</label>
                                    <select class="form-select" id="type" name="type">
                                        <option value="all" <?= $filter_type === 'all' ? 'selected' : '' ?>>All Reports</option>
                                        <option value="start_list" <?= $filter_type === 'start_list' ? 'selected' : '' ?>>Start Lists Only</option>
                                        <option value="summary_table" <?= $filter_type === 'summary_table' ? 'selected' : '' ?>>Summary Tables Only</option>
                                    </select>
                                </div>
                                
                                <div class="col-md-4 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-play me-1"></i>Test API
                                    </button>
                                </div>
                            </div>
                        </form>

                        <!-- Test URLs -->
                        <div class="alert alert-info">
                            <h6><i class="fas fa-link me-2"></i>Direct API URLs:</h6>
                            <ul class="mb-0">
                                <li><a href="../api/reports_api.php?event_id=<?= $event_id ?>" target="_blank">All Reports</a></li>
                                <li><a href="../api/reports_api.php?event_id=<?= $event_id ?>&type=start_list" target="_blank">Start Lists Only</a></li>
                                <li><a href="../api/reports_api.php?event_id=<?= $event_id ?>&type=summary_table" target="_blank">Summary Tables Only</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row mt-4">
            <div class="col-12">
                <div class="border-0 shadow-none card">
                    <div class="border-0 shadow-none card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">
                            <i class="fas fa-code me-2"></i>API Response
                        </h6>
                        <div class="badge bg-secondary">
                            Event ID: <?= htmlspecialchars($event_id) ?> | Filter: <?= htmlspecialchars($filter_type) ?>
                        </div>
                    </div>
                    <div class="border-0 shadow-none card-body p-0">
                        <pre class="json-output p-3 mb-0" style="max-height: 600px; overflow-y: auto;"><?php
                            if ($api_response) {
                                echo htmlspecialchars(json_encode($api_response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
                            } else {
                                echo htmlspecialchars($output);
                            }
                        ?></pre>
                    </div>
                </div>
            </div>
        </div>
        
        <?php if ($api_response && isset($api_response['reports'])): ?>
        <div class="row mt-4">
            <div class="col-12">
                <div class="border-0 shadow-none card">
                    <div class="border-0 shadow-none card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-table me-2"></i>Reports Table Preview
                        </h6>
                    </div>
                    <div class="border-0 shadow-none card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover table-sm mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Heat</th>
                                        <th>Category</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($api_response['reports'] as $report): ?>
                                        <tr>
                                            <td><?= $report['id'] ?></td>
                                            <td>
                                                <div class="fw-bold"><?= htmlspecialchars($report['name']) ?></div>
                                                <small class="text-<?= $report['type_info']['color'] ?>">
                                                    <i class="fas <?= $report['type_info']['icon'] ?> me-1"></i><?= $report['type_info']['label'] ?>
                                                </small>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?= $report['type_info']['color'] ?>"><?= $report['type'] ?></span>
                                            </td>
                                            <td>
                                                <span class="badge bg-secondary"><?= $report['heat_badge'] ?></span>
                                            </td>
                                            <td><?= $report['category'] ? htmlspecialchars($report['category']) : '<em>None</em>' ?></td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="<?= htmlspecialchars($report['urls']['pdf']) ?>" class="btn btn-outline-danger" title="PDF" target="_blank">
                                                        <i class="fas fa-file-pdf"></i>
                                                    </a>
                                                    <a href="<?= htmlspecialchars($report['urls']['html']) ?>" class="btn btn-outline-dark" title="HTML" target="_blank">
                                                        <i class="fas fa-code"></i>
                                                    </a>
                                                    <a href="<?= htmlspecialchars($report['urls']['csv']) ?>" class="btn btn-outline-primary" title="CSV">
                                                        <i class="fas fa-file-csv"></i>
                                                    </a>
                                                    <a href="<?= htmlspecialchars($report['urls']['json']) ?>" class="btn btn-outline-success" title="JSON" target="_blank">
                                                        <i class="fas fa-code"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Statistics -->
                        <div class="row m-3 pt-3 border-top">
                            <div class="col-md-4 text-center">
                                <div class="h5 text-success mb-1"><?= $api_response['stats']['start_list_count'] ?></div>
                                <small class="text-muted">Start Lists</small>
                            </div>
                            <div class="col-md-4 text-center">
                                <div class="h5 text-info mb-1"><?= $api_response['stats']['summary_table_count'] ?></div>
                                <small class="text-muted">Summary Tables</small>
                            </div>
                            <div class="col-md-4 text-center">
                                <div class="h5 text-primary mb-1"><?= $api_response['stats']['total_reports'] ?></div>
                                <small class="text-muted">Total Reports</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="row mt-4">
            <div class="col-12">
                <div class="border-0 shadow-none card">
                    <div class="border-0 shadow-none card-header">
                        <h6 class="mb-0">
                            <i class="fas fa-info-circle me-2"></i>Usage Information
                        </h6>
                    </div>
                    <div class="border-0 shadow-none card-body">
                        <h6>API Endpoints:</h6>
                        <ul>
                            <li><code>GET /api/reports_api.php?event_id={id}</code> - Get all reports for event</li>
                            <li><code>GET /api/reports_api.php?event_id={id}&type=start_list</code> - Get only start lists</li>
                            <li><code>GET /api/reports_api.php?event_id={id}&type=summary_table</code> - Get only summary tables</li>
                        </ul>
                        
                        <h6 class="mt-3">Parameters:</h6>
                        <ul>
                            <li><strong>event_id</strong> (required) - The event ID to fetch reports for</li>
                            <li><strong>type</strong> (optional) - Filter by report type: 'all', 'start_list', 'summary_table'</li>
                            <li><strong>format</strong> (optional) - Response format: 'json' (default), 'array' (for internal use)</li>
                        </ul>
                        
                        <div class="alert alert-warning mt-3">
                            <strong>Note:</strong> If you're getting CORS errors in your browser, make sure you're accessing this page through a web server (like http://localhost/stylescore2025/htdocs/v2/admin/test_reports_api.php) rather than opening the HTML file directly.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</body>
</html>
