<?php
// Test real publish functionality to ensure no 500 errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Simulate POST request to publish endpoint
$_POST['action'] = 'publish_now';
$_POST['server_id'] = '1'; // Assuming server ID 1 exists

// Capture output
ob_start();

// Include the actual publish_servers.php logic 
require_once 'publish_servers.php';

$output = ob_get_clean();

echo "=== PUBLISH TEST OUTPUT ===\n";
echo $output;
echo "\n=== END OUTPUT ===\n";

// Check if it's valid JSON
$json_data = json_decode($output, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "\n✅ Valid JSON response received\n";
    if (isset($json_data['success'])) {
        echo "Success status: " . ($json_data['success'] ? 'true' : 'false') . "\n";
        if (isset($json_data['message'])) {
            echo "Message: " . $json_data['message'] . "\n";
        }
    }
} else {
    echo "\n❌ Invalid JSON response: " . json_last_error_msg() . "\n";
    echo "Raw output length: " . strlen($output) . " characters\n";
}
?>
