<?php
// Direct test of publish functionality without auth
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Simulate proper web environment
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['REQUEST_SCHEME'] = 'http';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/v2/admin/publish_servers.php';

// Only include what we need
require_once '../includes/db.php';
require_once 'publish_generators.php';

// Test with existing server from database
try {
    $server_id = 2;
    
    // Get server configuration
    $stmt = $pdo->prepare("SELECT * FROM publish_servers WHERE id = ?");
    $stmt->execute([$server_id]);
    $server = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$server) {
        echo json_encode(['success' => false, 'message' => 'Server not found']);
        exit;
    }
    
    echo "Server found: " . $server['name'] . "\n";
    echo "Event ID: " . $server['event_id'] . "\n";
    echo "Data types: " . $server['data_types'] . "\n";
    
    // Test generating files
    $temp_dir = sys_get_temp_dir() . '/publish_test_' . time();
    mkdir($temp_dir, 0755, true);
    
    $all_files = [];
    $data_types = json_decode($server['data_types'], true);
    
    echo "Testing data types:\n";
    foreach ($data_types as $data_type) {
        echo "- Processing: $data_type\n";
        switch ($data_type) {
            case 'html_dashboard':
                $files = generateStaticHTMLDashboard($server['event_id'], $temp_dir, $pdo);
                $all_files = array_merge($all_files, $files);
                echo "  Generated " . count($files) . " HTML dashboard files\n";
                break;
            case 'json_data':
                $files = generateJSONData($server['event_id'], $temp_dir, $pdo);
                $all_files = array_merge($all_files, $files);
                echo "  Generated " . count($files) . " JSON data files\n";
                break;
            case 'csv_data':
                $files = generateCSVData($server['event_id'], $temp_dir, $pdo);
                $all_files = array_merge($all_files, $files);
                echo "  Generated " . count($files) . " CSV data files\n";
                break;
        }
    }
    
    echo "\n✅ SUCCESS: Generated " . count($all_files) . " total files\n";
    echo "Final JSON response would be:\n";
    echo json_encode([
        'success' => true, 
        'message' => 'Publish completed successfully',
        'file_count' => count($all_files),
        'server_name' => $server['name']
    ], JSON_PRETTY_PRINT);
    
    // Cleanup
    foreach ($all_files as $file) {
        if (file_exists($file['local'])) {
            unlink($file['local']);
        }
    }
    
    // Remove temp directory (check if empty first)
    $remaining_files = scandir($temp_dir);
    if (count($remaining_files) <= 2) { // . and .. only
        rmdir($temp_dir);
    }
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
