<?php
// Test the exact publish_now action in isolation
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create logs directory if it doesn't exist
$log_dir = 'C:\stylescore2025\php\logs';
if (!is_dir($log_dir)) {
    mkdir($log_dir, 0755, true);
}

// Enable error logging
ini_set('log_errors', 1);
ini_set('error_log', $log_dir . '\php_error_log');

echo "Testing publish_now action...\n";

try {
    require_once '../includes/db.php';
    
    // Get a real server configuration
    $stmt = $pdo->query("SELECT * FROM publish_servers WHERE event_id = 3 LIMIT 1");
    $server = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$server) {
        echo "No publish server found for event 3\n";
        exit;
    }
    
    echo "Found server: " . $server['name'] . "\n";
    echo "Data types: " . $server['data_types'] . "\n";
    
    // Simulate the exact POST request
    $_POST = [
        'action' => 'publish_now',
        'id' => $server['id']
    ];
    $_SERVER['REQUEST_METHOD'] = 'POST';
    
    echo "Simulating POST request...\n";
    
    // Start output buffering to capture any output
    ob_start();
    
    // Include the publish_servers.php file
    include 'publish_servers.php';
    
    $output = ob_get_clean();
    
    echo "Output captured (" . strlen($output) . " bytes):\n";
    if (strlen($output) > 0) {
        echo "OUTPUT: " . $output . "\n";
        
        // Check if it's valid JSON
        $json = json_decode($output, true);
        if ($json === null) {
            echo "ERROR: Output is not valid JSON\n";
            echo "First 500 chars: " . substr($output, 0, 500) . "\n";
        } else {
            echo "SUCCESS: Valid JSON response\n";
            print_r($json);
        }
    } else {
        echo "No output captured\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
}
?>
