<?php
require_once '../includes/db.php';

echo "<h2>Photo Path Test</h2>";

// Check current directory structure
echo "<h3>Directory Structure Check</h3>";
echo "<p>Current script location: " . __FILE__ . "</p>";
echo "<p>Admin directory: " . __DIR__ . "</p>";
echo "<p>Parent directory: " . dirname(__DIR__) . "</p>";
echo "<p>Grandparent directory: " . dirname(dirname(__DIR__)) . "</p>";

// Check for uploads directories
echo "<h3>Looking for uploads directories:</h3>";
$possible_upload_dirs = [
    dirname(__DIR__) . '/uploads',
    dirname(dirname(__DIR__)) . '/uploads',
    '../uploads',
    '../../uploads'
];

foreach ($possible_upload_dirs as $dir) {
    $real_path = realpath($dir);
    if ($real_path && is_dir($real_path)) {
        echo "<p style='color: green;'>✓ Found: $dir (resolved to: $real_path)</p>";
        
        // List subdirectories
        $subdirs = glob($real_path . '/*', GLOB_ONLYDIR);
        if (!empty($subdirs)) {
            echo "<ul>";
            foreach ($subdirs as $subdir) {
                echo "<li>" . basename($subdir) . "</li>";
            }
            echo "</ul>";
        }
        
        // List some files
        $files = array_slice(glob($real_path . '/*.*'), 0, 5);
        if (!empty($files)) {
            echo "<p>Sample files:</p><ul>";
            foreach ($files as $file) {
                echo "<li>" . basename($file) . "</li>";
            }
            echo "</ul>";
        }
    } else {
        echo "<p style='color: red;'>✗ Not found: $dir</p>";
    }
}

// Test with actual participant photos
echo "<h3>Testing Participant Photos</h3>";
try {
    $stmt = $pdo->prepare("
        SELECT p.id, p.photo, p.first_name, p.last_name, ep.bib_number
        FROM participants p
        INNER JOIN event_participants ep ON p.id = ep.participant_id
        WHERE p.photo IS NOT NULL AND p.photo != ''
        LIMIT 5
    ");
    $stmt->execute();
    $participants = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<p>Found " . count($participants) . " participants with photos:</p>";
    
    foreach ($participants as $participant) {
        echo "<h4>Participant: {$participant['first_name']} {$participant['last_name']} (BIB: {$participant['bib_number']})</h4>";
        echo "<p>Photo filename: " . htmlspecialchars($participant['photo']) . "</p>";
        
        // Try different possible photo paths
        $possible_paths = [
            dirname(__DIR__) . '/uploads/' . $participant['photo'],
            dirname(__DIR__) . '/uploads/participants/' . $participant['photo'],
            dirname(__DIR__) . '/uploads/profile_stills/' . $participant['photo'],
            dirname(dirname(__DIR__)) . '/uploads/' . $participant['photo'],
            dirname(dirname(__DIR__)) . '/v2/uploads/' . $participant['photo'],
            '../uploads/' . $participant['photo'],
            '../../uploads/' . $participant['photo']
        ];
        
        $found = false;
        foreach ($possible_paths as $path) {
            $real_path = realpath($path);
            if ($real_path && file_exists($real_path) && is_readable($real_path)) {
                echo "<p style='color: green;'>✓ Found at: $path (resolved to: $real_path)</p>";
                echo "<p>File size: " . filesize($real_path) . " bytes</p>";
                $found = true;
                break;
            }
        }
        
        if (!$found) {
            echo "<p style='color: red;'>✗ Photo not found in any of the tested paths</p>";
            echo "<details><summary>Tested paths:</summary><ul>";
            foreach ($possible_paths as $path) {
                echo "<li>$path</li>";
            }
            echo "</ul></details>";
        }
        
        echo "<hr>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}

// Test assets
echo "<h3>Testing Asset Files</h3>";
$possible_css_paths = [
    dirname(__DIR__) . '/assets/css/custom-dashboard.css',
    dirname(dirname(__DIR__)) . '/assets/css/custom-dashboard.css',
    '../assets/css/custom-dashboard.css',
    '../../assets/css/custom-dashboard.css'
];

echo "<h4>Looking for CSS files:</h4>";
foreach ($possible_css_paths as $path) {
    $real_path = realpath($path);
    if ($real_path && file_exists($real_path)) {
        echo "<p style='color: green;'>✓ Found CSS: $path (resolved to: $real_path)</p>";
    } else {
        echo "<p style='color: red;'>✗ CSS not found: $path</p>";
    }
}

$possible_logo_paths = [
    dirname(__DIR__) . '/assets/img/SVG/logo-ss-_2.svg',
    dirname(dirname(__DIR__)) . '/assets/img/SVG/logo-ss-_2.svg',
    '../assets/img/SVG/logo-ss-_2.svg',
    '../../assets/img/SVG/logo-ss-_2.svg'
];

echo "<h4>Looking for logo files:</h4>";
foreach ($possible_logo_paths as $path) {
    $real_path = realpath($path);
    if ($real_path && file_exists($real_path)) {
        echo "<p style='color: green;'>✓ Found logo: $path (resolved to: $real_path)</p>";
    } else {
        echo "<p style='color: red;'>✗ Logo not found: $path</p>";
    }
}
?>
