<?php
require_once '../includes/db.php';

echo "<h2>Path Verification Test</h2>";

// Test the exact paths you mentioned
echo "<h3>Testing Exact Paths</h3>";

$working_path = 'C:\stylescore2025\htdocs\v2/uploads/profile_stills/f_7.png';
$expected_path = 'C:\stylescore2025\htdocs\v2/uploads/profile_stills/f_7.png';

echo "<p><strong>Working path:</strong> " . htmlspecialchars($working_path) . "</p>";
echo "<p><strong>Expected path:</strong> " . htmlspecialchars($expected_path) . "</p>";

// Check if both paths work
if (file_exists($working_path)) {
    echo "<p style='color: green;'>✅ Working path exists and is readable</p>";
    echo "<p>File size: " . filesize($working_path) . " bytes</p>";
} else {
    echo "<p style='color: red;'>❌ Working path not accessible</p>";
}

if (file_exists($expected_path)) {
    echo "<p style='color: green;'>✅ Expected path exists and is readable</p>";
    echo "<p>File size: " . filesize($expected_path) . " bytes</p>";
} else {
    echo "<p style='color: red;'>❌ Expected path not accessible</p>";
}

// Test our path generation logic
echo "<h3>Testing Path Generation Logic</h3>";

$test_filename = 'f_7.png';

$generated_paths = [
    'Direct absolute' => 'C:\stylescore2025\htdocs\v2/uploads/profile_stills/' . $test_filename,
    'dirname(__DIR__)' => dirname(__DIR__) . '/uploads/profile_stills/' . $test_filename,
    'realpath version' => realpath(dirname(__DIR__) . '/uploads/profile_stills') . DIRECTORY_SEPARATOR . $test_filename,
    'Relative path' => '../uploads/profile_stills/' . $test_filename
];

foreach ($generated_paths as $method => $path) {
    echo "<h4>$method:</h4>";
    echo "<p>Generated: " . htmlspecialchars($path) . "</p>";
    
    if (file_exists($path)) {
        echo "<p style='color: green;'>✅ EXISTS and readable</p>";
        echo "<p>File size: " . filesize($path) . " bytes</p>";
    } else {
        echo "<p style='color: red;'>❌ Does not exist or not readable</p>";
        
        // Try to get realpath
        $real = realpath($path);
        if ($real) {
            echo "<p>Realpath resolves to: " . htmlspecialchars($real) . "</p>";
        } else {
            echo "<p>Realpath failed</p>";
        }
    }
    echo "<hr>";
}

// Check what dirname(__DIR__) actually resolves to
echo "<h3>Path Resolution Debug</h3>";
echo "<p><strong>Current script:</strong> " . __FILE__ . "</p>";
echo "<p><strong>__DIR__:</strong> " . __DIR__ . "</p>";
echo "<p><strong>dirname(__DIR__):</strong> " . dirname(__DIR__) . "</p>";
echo "<p><strong>Profile stills dir:</strong> " . dirname(__DIR__) . '/uploads/profile_stills' . "</p>";

$profile_stills_dir = dirname(__DIR__) . '/uploads/profile_stills';
if (is_dir($profile_stills_dir)) {
    echo "<p style='color: green;'>✅ Profile stills directory exists</p>";
    
    // List a few files
    $files = glob($profile_stills_dir . '/*.{png,jpg,jpeg}', GLOB_BRACE);
    echo "<p>Found " . count($files) . " image files in directory</p>";
    
    if (count($files) > 0) {
        echo "<p>Sample files:</p><ul>";
        foreach (array_slice($files, 0, 5) as $file) {
            echo "<li>" . basename($file) . "</li>";
        }
        echo "</ul>";
    }
} else {
    echo "<p style='color: red;'>❌ Profile stills directory not found</p>";
}

// Test with a participant from the database
echo "<h3>Test with Real Participant Data</h3>";
try {
    $stmt = $pdo->prepare("
        SELECT p.photo 
        FROM participants p
        INNER JOIN event_participants ep ON p.id = ep.participant_id  
        WHERE ep.event_id = 3 AND p.photo IS NOT NULL AND p.photo != ''
        LIMIT 1
    ");
    $stmt->execute();
    $participant = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($participant) {
        $photo_filename = $participant['photo'];
        echo "<p>Testing with real photo: " . htmlspecialchars($photo_filename) . "</p>";
        
        $test_path = dirname(__DIR__) . '/uploads/profile_stills/' . $photo_filename;
        echo "<p>Generated path: " . htmlspecialchars($test_path) . "</p>";
        
        if (file_exists($test_path)) {
            echo "<p style='color: green; font-weight: bold;'>✅ SUCCESS! Photo found at generated path</p>";
            echo "<p>File size: " . filesize($test_path) . " bytes</p>";
        } else {
            echo "<p style='color: red;'>❌ Photo not found at generated path</p>";
            
            // Try the absolute path format
            $abs_path = 'C:\stylescore2025\htdocs\v2/uploads/profile_stills/' . $photo_filename;
            if (file_exists($abs_path)) {
                echo "<p style='color: green;'>✅ But found at absolute path: " . htmlspecialchars($abs_path) . "</p>";
            }
        }
    } else {
        echo "<p>No participants with photos found in Event 3</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
