<?php
// Minimal test of head_judge_override.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Starting head judge override test...<br>";

try {
    echo "1. Including auth.php...<br>";
    include '../includes/auth.php';
    echo "Auth included successfully<br>";
    
    echo "2. Including db.php...<br>";
    include '../includes/db.php';
    echo "Database included successfully<br>";
    
    echo "3. Checking session...<br>";
    if (!isset($_SESSION['user_type'])) {
        echo "No user_type in session<br>";
    } else {
        echo "User type: " . $_SESSION['user_type'] . "<br>";
    }
    
    echo "4. Testing database query...<br>";
    $events = $pdo->query("SELECT id, name, date FROM events ORDER BY date DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
    echo "Found " . count($events) . " events<br>";
    
    echo "5. All basic functionality working!<br>";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br>";
    echo "Stack trace: <pre>" . $e->getTraceAsString() . "</pre>";
}
?>
