<?php
echo "FTP Extension Test\n";
echo "==================\n";

// Check if FTP extension is loaded
if (extension_loaded('ftp')) {
    echo "✅ FTP extension is loaded\n";
    
    // Test basic FTP functions
    if (function_exists('ftp_connect')) {
        echo "✅ ftp_connect function exists\n";
    } else {
        echo "❌ ftp_connect function missing\n";
    }
    
    if (function_exists('ftp_login')) {
        echo "✅ ftp_login function exists\n";
    } else {
        echo "❌ ftp_login function missing\n";
    }
    
    if (function_exists('ftp_put')) {
        echo "✅ ftp_put function exists\n";
    } else {
        echo "❌ ftp_put function missing\n";
    }
    
} else {
    echo "❌ FTP extension is NOT loaded\n";
    echo "Available extensions:\n";
    $extensions = get_loaded_extensions();
    foreach ($extensions as $ext) {
        if (stripos($ext, 'ftp') !== false || stripos($ext, 'curl') !== false) {
            echo "  - $ext\n";
        }
    }
}

echo "\nPHP Info:\n";
echo "PHP Version: " . phpversion() . "\n";
echo "OS: " . PHP_OS . "\n";

// Check sys_get_temp_dir
echo "\nTemp Directory:\n";
$temp_dir = sys_get_temp_dir();
echo "Temp dir: $temp_dir\n";
echo "Writable: " . (is_writable($temp_dir) ? "Yes" : "No") . "\n";

// Test temp directory creation
$test_dir = $temp_dir . '/stylescore_test_' . time();
if (mkdir($test_dir, 0755, true)) {
    echo "✅ Can create temp directories\n";
    rmdir($test_dir);
} else {
    echo "❌ Cannot create temp directories\n";
}
?>
