<?php
require_once '../includes/db.php';
require_once 'publish_generators.php';

// Get server and event info
$server_id = isset($_GET['server_id']) ? (int)$_GET['server_id'] : 3;
$event_id = isset($_GET['event_id']) ? (int)$_GET['event_id'] : 3;

echo "<h2>Testing File Generation</h2>";
echo "<p>Server ID: $server_id, Event ID: $event_id</p>";

// Get server config
$stmt = $pdo->prepare("SELECT * FROM publish_servers WHERE id = ?");
$stmt->execute([$server_id]);
$server = $stmt->fetch();

if (!$server) {
    die("Server not found!");
}

echo "<h3>Server Config:</h3>";
echo "<pre>" . print_r($server, true) . "</pre>";

// Create temp directory
$temp_dir = sys_get_temp_dir() . '/stylescore_publish_' . $server_id . '_' . $event_id;
if (!is_dir($temp_dir)) {
    mkdir($temp_dir, 0777, true);
}

echo "<h3>Temporary Directory: $temp_dir</h3>";

// Test each generator
$file_types = explode(',', $server['file_types']);
$all_files = [];

foreach ($file_types as $type) {
    $type = trim($type);
    echo "<h4>Testing: $type</h4>";
    
    try {
        switch ($type) {
            case 'html_dashboard':
                $files = generateHTMLDashboard($event_id, $temp_dir, $pdo);
                break;
            case 'pdf_results':
                $files = generatePDFResults($event_id, $temp_dir, $pdo);
                break;
            case 'csv_summary':
                $files = generateCSVSummary($event_id, $temp_dir, $pdo);
                break;
            case 'csv_startlist':
                $files = generateCSVStartList($event_id, $temp_dir, $pdo);
                break;
            default:
                echo "Unknown file type: $type<br>";
                continue 2;
        }
        
        echo "Generated " . count($files) . " files:<br>";
        foreach ($files as $file) {
            echo "- " . $file['remote'];
            if (file_exists($file['local'])) {
                $size = filesize($file['local']);
                echo " (✓ $size bytes)";
            } else {
                echo " (✗ NOT FOUND)";
            }
            echo "<br>";
        }
        
        $all_files = array_merge($all_files, $files);
        
    } catch (Exception $e) {
        echo "ERROR: " . $e->getMessage() . "<br>";
    }
    
    echo "<br>";
}

echo "<h3>Summary: " . count($all_files) . " total files generated</h3>";

// Test directory listing
echo "<h3>Directory Contents:</h3>";
if (is_dir($temp_dir)) {
    $contents = scandir($temp_dir);
    foreach ($contents as $item) {
        if ($item != '.' && $item != '..') {
            $path = $temp_dir . '/' . $item;
            if (is_dir($path)) {
                echo "📁 $item/<br>";
                $subcontents = scandir($path);
                foreach ($subcontents as $subitem) {
                    if ($subitem != '.' && $subitem != '..') {
                        $size = filesize($path . '/' . $subitem);
                        echo "&nbsp;&nbsp;📄 $subitem ($size bytes)<br>";
                    }
                }
            } else {
                $size = filesize($path);
                echo "📄 $item ($size bytes)<br>";
            }
        }
    }
} else {
    echo "Directory not found!";
}
?>
