<?php
// Simple test to verify the eventId fix is working
error_reporting(0); // Suppress warnings for clean output

// Set proper server variables
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['REQUEST_SCHEME'] = 'http';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/v2/admin/publish_servers.php';

require_once '../includes/db.php';
require_once 'publish_generators.php';

// Test generating HTML dashboard only
$event_id = 3; // Use existing event ID
$temp_dir = sys_get_temp_dir() . '/dashboard_test_' . time();
mkdir($temp_dir, 0755, true);

try {
    echo "Testing HTML dashboard generation...\n";
    $files = generateStaticHTMLDashboard($event_id, $temp_dir, $pdo);
    
    // Check if dashboard.js was generated
    $dashboard_js_file = null;
    foreach ($files as $file) {
        if ($file['remote'] === 'dashboard.js') {
            $dashboard_js_file = $file['local'];
            break;
        }
    }
    
    if ($dashboard_js_file && file_exists($dashboard_js_file)) {
        echo "✅ dashboard.js generated successfully\n";
        
        // Check if the eventId fix is applied
        $js_content = file_get_contents($dashboard_js_file);
        
        // Look for the specific fix we made
        if (strpos($js_content, 'general-reports-${event.id}') !== false) {
            echo "✅ eventId fix applied correctly - uses 'event.id' in template\n";
        } else if (strpos($js_content, 'general-reports-${eventId}') !== false) {
            echo "❌ Fix not applied - still uses undefined 'eventId' variable\n";
        } else {
            echo "⚠️ Could not find general-reports template in JS\n";
        }
        
        // Count occurrences of the pattern to make sure we got them all
        $fixed_count = substr_count($js_content, '${event.id}');
        $broken_count = substr_count($js_content, '${eventId}');
        
        echo "Template literal analysis:\n";
        echo "- Uses '\${event.id}': $fixed_count occurrences\n"; 
        echo "- Uses '\${eventId}': $broken_count occurrences\n";
        
        if ($broken_count === 0) {
            echo "✅ All eventId references are correctly using 'event.id'\n";
        } else {
            echo "❌ Still has $broken_count incorrect 'eventId' references\n";
        }
        
        echo "\nFile size: " . number_format(filesize($dashboard_js_file)) . " bytes\n";
        
    } else {
        echo "❌ dashboard.js not found in generated files\n";
    }
    
    // Cleanup
    foreach ($files as $file) {
        if (file_exists($file['local'])) {
            unlink($file['local']);
        }
    }
    rmdir($temp_dir);
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
