<?php
require_once '../includes/config.php';
require_once 'publish_generators.php';

echo "Regenerating remote dashboard with fixes...\n";

$event_id = 3; // Event 3
$temp_dir = sys_get_temp_dir() . '/stylescore_publish_' . uniqid();

if (!is_dir($temp_dir)) {
    mkdir($temp_dir, 0755, true);
}

echo "Temp directory: $temp_dir\n";

try {
    // Generate HTML dashboard
    echo "Generating HTML dashboard...\n";
    $files = generateHTMLDashboard($event_id, $temp_dir, $pdo);
    
    echo "Generated files:\n";
    foreach ($files as $file) {
        echo "  {$file['local']} -> {$file['remote']}\n";
        if (file_exists($file['local'])) {
            echo "    Size: " . filesize($file['local']) . " bytes\n";
        } else {
            echo "    ERROR: File not found!\n";
        }
    }
    
    echo "\nHTML dashboard generated successfully with fixes for heats data structure!\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

// Clean up
if (is_dir($temp_dir)) {
    // Remove temp files
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($temp_dir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );
    
    foreach ($iterator as $file) {
        if ($file->isDir()) {
            rmdir($file->getRealPath());
        } else {
            unlink($file->getRealPath());
        }
    }
    rmdir($temp_dir);
}

echo "Test completed.\n";
?>
