<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../includes/auth.php';
include '../includes/db.php';

echo "Auth included\n";
echo "DB included\n";

$selected_event = $_GET['event_id'] ?? null;
echo "Selected event: " . ($selected_event ?? 'NULL') . "\n";

$view_type = $_GET['view_type'] ?? 'summary_table';
echo "View type: $view_type\n";

// Test events query
try {
    $events = $pdo->query("SELECT id, name FROM events ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
    echo "Events found: " . count($events) . "\n";
} catch (Exception $e) {
    echo "ERROR querying events: " . $e->getMessage() . "\n";
}

// Test heats query
if ($selected_event) {
    try {
        $stmt = $pdo->prepare("SELECT heat_number, heat_name FROM event_heat_settings WHERE event_id = ? ORDER BY heat_number ASC");
        $stmt->execute([$selected_event]);
        $heats = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "Heats found: " . count($heats) . "\n";
    } catch (Exception $e) {
        echo "ERROR querying heats: " . $e->getMessage() . "\n";
    }
}
