<?php
// Test that the database field exists and functionality works
try {
    include_once '../includes/db.php';
    
    echo "=== Testing bib_performing Field ===\n";
    
    // Test 1: Check if column exists
    $stmt = $pdo->query('DESCRIBE event_heat_settings');
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    if (in_array('bib_performing', $columns)) {
        echo "✅ SUCCESS: bib_performing column exists\n";
    } else {
        echo "❌ ERROR: bib_performing column missing\n";
        exit(1);
    }
    
    // Test 2: Check if we can read/write to the field
    $test_event_id = 1; // Use event ID 1 for testing
    
    // Try to update bib_performing field
    $stmt = $pdo->prepare("UPDATE event_heat_settings SET bib_performing = ? WHERE event_id = ? LIMIT 1");
    $result = $stmt->execute([999, $test_event_id]);
    
    if ($result) {
        echo "✅ SUCCESS: Can write to bib_performing field\n";
        
        // Try to read it back
        $stmt = $pdo->prepare("SELECT bib_performing FROM event_heat_settings WHERE event_id = ? AND bib_performing = 999 LIMIT 1");
        $stmt->execute([$test_event_id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($data && $data['bib_performing'] == 999) {
            echo "✅ SUCCESS: Can read from bib_performing field\n";
            
            // Clean up test data
            $stmt = $pdo->prepare("UPDATE event_heat_settings SET bib_performing = NULL WHERE event_id = ? AND bib_performing = 999");
            $stmt->execute([$test_event_id]);
            echo "✅ SUCCESS: Test data cleaned up\n";
        } else {
            echo "❌ ERROR: Cannot read from bib_performing field\n";
        }
    } else {
        echo "❌ ERROR: Cannot write to bib_performing field\n";
    }
    
    echo "\n=== Field Mapping Test Complete ===\n";
    echo "The PERFORMING NOW feature should work correctly!\n";
    echo "When you set a participant to 'PERFORMING NOW':\n";
    echo "1. Input field 'bibPerforming' → saves to database field 'bib_performing'\n";
    echo "2. Display boxes read from 'bibPerforming' input field\n";
    echo "3. Auto-save triggers on input change\n";
    echo "4. Live updates refresh every 3 seconds\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
}
?>
