-- Migration to allow multiple source heats
-- Changes flow_source_heat from int(11) to VARCHAR to store JSON array

ALTER TABLE `event_heat_settings` 
MODIFY COLUMN `flow_source_heat` VARCHAR(255) DEFAULT NULL 
COMMENT 'JSON array of source heat numbers or single heat number';

-- Update existing data to JSON format
UPDATE `event_heat_settings` 
SET `flow_source_heat` = CONCAT('[', `flow_source_heat`, ']')
WHERE `flow_source_heat` IS NOT NULL 
AND `flow_source_heat` != ''
AND `flow_source_heat` NOT LIKE '[%';
