<?php
include '../includes/auth.php';
include '../includes/db.php';

echo "<h1>Adding Scoring Layout Configuration Fields</h1>";

try {
    // Add scoring layout fields to events table
    echo "<h2>Events Table - Adding scoring layout configuration...</h2>";
    
    $queries = [
        "ALTER TABLE events ADD COLUMN scoring_layout_config JSON DEFAULT NULL COMMENT 'JSON config for scoring panel layout'",
        "ALTER TABLE event_heat_settings ADD COLUMN scoring_layout_config JSON DEFAULT NULL COMMENT 'JSON config for heat-specific scoring panel layout'"
    ];
    
    foreach ($queries as $query) {
        try {
            $pdo->exec($query);
            echo "<div style='color: green;'>✓ " . htmlspecialchars($query) . "</div>";
        } catch (PDOException $e) {
            // Check if column already exists
            if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
                echo "<div style='color: orange;'>~ Column already exists: " . htmlspecialchars($query) . "</div>";
            } else {
                echo "<div style='color: red;'>✗ Error: " . htmlspecialchars($e->getMessage()) . "</div>";
                echo "<div style='color: red;'>Query: " . htmlspecialchars($query) . "</div>";
            }
        }
    }
    
    echo "<h2>Creating Default Configuration...</h2>";
    
    // Define default scoring layout configuration
    $defaultConfig = [
        'cards' => [
            'criteriaInputGrid' => [
                'enabled' => true,
                'title' => 'Criteria Scoring',
                'description' => 'Individual criteria input fields with sliders'
            ],
            'finalCalculatedScore' => [
                'enabled' => true, 
                'title' => 'Final Score Display',
                'description' => 'Shows calculated final score from criteria'
            ],
            'figuresCard' => [
                'enabled' => true,
                'title' => 'Figures Selection',
                'description' => 'Figure selection chips and diversity validation'
            ],
            'latestScores' => [
                'enabled' => true,
                'title' => 'Latest Scores',
                'description' => 'Recent scores table with edit/overwrite options'
            ],
            'otherHeatScores' => [
                'enabled' => true,
                'title' => 'Other Heat Scores', 
                'description' => 'Scores from other judges for current participant'
            ],
            'diversityValidation' => [
                'enabled' => true,
                'title' => 'Diversity Validation',
                'description' => 'Real-time figure diversity rule checking'
            ],
            'figureHistory' => [
                'enabled' => true,
                'title' => 'Figure History',
                'description' => 'Previous figure selections across runs'
            ],
            'formatInfo' => [
                'enabled' => true,
                'title' => 'Format Information',
                'description' => 'Scoring format details and rules'
            ]
        ],
        'layout' => [
            'compactMode' => false,
            'cardsPerRow' => 'auto',
            'hideEmptyCards' => true
        ]
    ];
    
    echo "<pre>" . json_encode($defaultConfig, JSON_PRETTY_PRINT) . "</pre>";
    echo "<div style='color: green;'>✓ Default configuration defined</div>";
    
} catch (Exception $e) {
    echo "<div style='color: red;'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<h2>Database Update Complete</h2>";
echo "<p><a href='event_edit.php?id=3'>Test Event Edit Form</a></p>";
echo "<p><a href='admin_heat_config.php?event_id=3'>Test Heat Configuration</a></p>";
?>