<?php
/**
 * Migration: Change heat_number from INT to VARCHAR in result_configurations
 * This allows storing multiple heat numbers as JSON arrays
 */

require_once __DIR__ . '/../includes/db.php';

try {
    $pdo->beginTransaction();
    
    // Check current column type
    $check = $pdo->query("SHOW COLUMNS FROM result_configurations WHERE Field = 'heat_number'");
    $column_info = $check->fetch(PDO::FETCH_ASSOC);
    
    echo "Current column type: " . $column_info['Type'] . "\n";
    
    // Only alter if it's not already VARCHAR
    if (strpos($column_info['Type'], 'int') !== false) {
        // Convert existing integer values to strings (they'll still work)
        $sql = "ALTER TABLE `result_configurations` 
                MODIFY COLUMN `heat_number` VARCHAR(255) DEFAULT NULL 
                COMMENT 'Heat number or JSON array of heat numbers'";
        
        $pdo->exec($sql);
        echo "✅ Successfully changed heat_number to VARCHAR(255)\n";
    } else {
        echo "ℹ️  Column heat_number is already VARCHAR, skipping migration\n";
    }
    
    $pdo->commit();
    echo "✅ Migration completed successfully!\n";
    
} catch (PDOException $e) {
    $pdo->rollBack();
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
?>
