<?php
include '../includes/db.php';

try {
    // Check if column exists
    $stmt = $pdo->prepare("SHOW COLUMNS FROM event_heat_settings LIKE 'bib_performing'");
    $stmt->execute();
    $exists = $stmt->fetch();
    
    if (!$exists) {
        echo "Adding bib_performing column...\n";
        $pdo->exec("ALTER TABLE event_heat_settings ADD COLUMN bib_performing INT DEFAULT NULL AFTER bib_latest_on_run");
        echo "Column added successfully!\n";
    } else {
        echo "Column bib_performing already exists.\n";
    }
    
    // Test the API endpoint
    echo "Testing API endpoint...\n";
    $response = file_get_contents("http://localhost/v2/admin/heat_management_api.php?action=get_data&event_id=1");
    if ($response) {
        $data = json_decode($response, true);
        if (isset($data['error'])) {
            echo "API Error: " . $data['error'] . "\n";
        } else {
            echo "API working correctly.\n";
        }
    } else {
        echo "API endpoint not responding.\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
