<?php
require_once '../includes/db.php';

echo "=== FIXING PUBLISH SERVERS DATA TYPES ===\n\n";

// Get all servers
$stmt = $pdo->query("SELECT id, name, data_types FROM publish_servers");
$servers = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($servers as $server) {
    $current_data_types = $server['data_types'];
    echo "Server: {$server['name']}\n";
    echo "Current data_types: $current_data_types\n";
    
    $decoded = json_decode($current_data_types, true);
    
    if ($decoded === null || empty($decoded)) {
        echo "  ❌ Invalid or empty data types, fixing...\n";
        
        // Set default data types
        $new_data_types = json_encode(['html_dashboard', 'json_data', 'csv_data']);
        
        $update_stmt = $pdo->prepare("UPDATE publish_servers SET data_types = ? WHERE id = ?");
        $update_stmt->execute([$new_data_types, $server['id']]);
        
        echo "  ✅ Updated to: $new_data_types\n";
    } else {
        echo "  ✅ Data types OK: " . implode(', ', $decoded) . "\n";
    }
    echo "\n";
}

echo "Fix complete!\n";
?>
