<?php
// Simple download script for exports

$file = $_GET['file'] ?? '';
$temp = $_GET['temp'] ?? '';

if (empty($file) || empty($temp)) {
    die('Invalid parameters');
}

// Security check - only allow specific patterns
if (!preg_match('/^export\.zip$/', $file) || !preg_match('/^stylescore_export_\d+_\d+$/', $temp)) {
    die('Invalid file pattern');
}

$temp_dir = sys_get_temp_dir() . '/' . $temp;
$file_path = $temp_dir . '/' . $file;

if (!file_exists($file_path)) {
    die('File not found');
}

// Output the file for download
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="stylescore_export_' . date('Y-m-d_H-i-s') . '.zip"');
header('Content-Length: ' . filesize($file_path));

readfile($file_path);

// Clean up
unlink($file_path);
$files = glob($temp_dir . '/*');
foreach ($files as $cleanup_file) {
    if (is_file($cleanup_file)) unlink($cleanup_file);
}
rmdir($temp_dir);

exit;
?>
