<?php
require_once '../includes/db.php';

echo "<h2>Server Configuration Debug</h2>";

$server_id = 3;
$stmt = $pdo->prepare("SELECT * FROM publish_servers WHERE id = ?");
$stmt->execute([$server_id]);
$server = $stmt->fetch();

if ($server) {
    echo "<h3>Current Server Configuration:</h3>";
    echo "<table border='1'>";
    foreach ($server as $key => $value) {
        echo "<tr><td><strong>$key</strong></td><td>" . htmlspecialchars($value) . "</td></tr>";
    }
    echo "</table>";
    
    echo "<h3>Data Types Analysis:</h3>";
    $data_types = json_decode($server['data_types'], true);
    if ($data_types === null) {
        echo "<p style='color: red;'>ERROR: Invalid JSON in data_types field!</p>";
        echo "<p>Raw value: " . htmlspecialchars($server['data_types']) . "</p>";
        $data_types = [$server['data_types']]; // fallback
    }
    
    echo "<p>Parsed data types:</p>";
    echo "<ul>";
    foreach ($data_types as $type) {
        echo "<li>$type</li>";
    }
    echo "</ul>";
    
    echo "<h3>What should be included for full upload:</h3>";
    echo "<ul>";
    echo "<li><strong>html_dashboard</strong> - Generates: index.html, dashboard.css, dashboard.js, data_overview.json, data_heats.json, data_scores.json, data_all.json, participant photos, assets</li>";
    echo "<li><strong>csv_summary</strong> - Generates: CSV summary files</li>";
    echo "<li><strong>csv_startlist</strong> - Generates: CSV start list files</li>";
    echo "<li><strong>pdf_results</strong> - Generates: PDF result files</li>";
    echo "</ul>";
    
    echo "<h3>Fix Data Types Button:</h3>";
    echo "<form method='post'>";
    echo "<input type='hidden' name='action' value='fix_data_types'>";
    echo "<input type='hidden' name='server_id' value='$server_id'>";
    echo "<button type='submit' style='background: orange; color: white; padding: 10px; border: none; cursor: pointer;'>Fix Data Types to Include All</button>";
    echo "</form>";
    
} else {
    echo "Server not found!";
}

// Handle fix action
if ($_POST['action'] == 'fix_data_types' && $_POST['server_id']) {
    $server_id = (int)$_POST['server_id'];
    $correct_data_types = json_encode(['html_dashboard', 'csv_summary', 'csv_startlist', 'pdf_results']);
    
    $update_stmt = $pdo->prepare("UPDATE publish_servers SET data_types = ? WHERE id = ?");
    $result = $update_stmt->execute([$correct_data_types, $server_id]);
    
    if ($result) {
        echo "<p style='color: green; font-weight: bold;'>✓ Data types updated successfully!</p>";
        echo "<script>setTimeout(() => window.location.reload(), 1000);</script>";
    } else {
        echo "<p style='color: red;'>✗ Failed to update data types</p>";
    }
}
?>
