<?php<?php

include '../includes/db.php';// Debug script to check event data

include '../includes/db.php';

$event_id = $_GET['id'] ?? 1;

$event_id = $_GET['id'] ?? 3; // Default to event ID 3 for testing

echo "<h2>Event Data Debug for Event ID: $event_id</h2>";

echo "<h2>Event Data Debug - Event ID: $event_id</h2>";

// Fetch the event data

$stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");// Fetch existing event data

$stmt->execute([$event_id]);$stmt = $pdo->prepare("SELECT * FROM events WHERE id = ?");

$event = $stmt->fetch(PDO::FETCH_ASSOC);$stmt->execute([$event_id]);

$event = $stmt->fetch(PDO::FETCH_ASSOC);

if ($event) {

    echo "<h3>Event Data from Database:</h3>";echo "<h3>Raw Event Array:</h3>";

    echo "<table border='1' style='border-collapse: collapse;'>";echo "<pre>";

    echo "<tr><th>Field</th><th>Value</th><th>Type</th></tr>";var_dump($event);

    echo "</pre>";

    foreach ($event as $field => $value) {

        echo "<tr>";echo "<h3>Key Fields Check:</h3>";

        echo "<td><strong>$field</strong></td>";echo "Name: " . ($event['name'] ?? 'NULL') . "<br>";

        echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";echo "Date: " . ($event['date'] ?? 'NULL') . "<br>";  

        echo "<td>" . gettype($value) . "</td>";echo "Location: " . ($event['location'] ?? 'NULL') . "<br>";

        echo "</tr>";echo "Sport Discipline: " . ($event['sport_discipline'] ?? 'NULL') . "<br>";

    }echo "Scoring Format: " . ($event['scoring_format'] ?? 'NULL') . "<br>";

    echo "</table>";echo "Scoring Mode: " . ($event['scoring_mode'] ?? 'NULL') . "<br>";

    echo "Status: " . ($event['status'] ?? 'NULL') . "<br>";

    // Show specific fields we care about

    echo "<hr><h3>Key Fields Analysis:</h3>";echo "<h3>Database Schema Check:</h3>";

    echo "<ul>";// Check what columns exist in the events table

    echo "<li><strong>sport_discipline:</strong> '" . ($event['sport_discipline'] ?? 'NULL') . "' (length: " . strlen($event['sport_discipline'] ?? '') . ")</li>";$stmt = $pdo->query("DESCRIBE events");

    echo "<li><strong>scoring_format:</strong> '" . ($event['scoring_format'] ?? 'NULL') . "' (length: " . strlen($event['scoring_format'] ?? '') . ")</li>";$columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<li><strong>scoring_mode:</strong> '" . ($event['scoring_mode'] ?? 'NULL') . "' (length: " . strlen($event['scoring_mode'] ?? '') . ")</li>";

    echo "<li><strong>location:</strong> '" . ($event['location'] ?? 'NULL') . "' (length: " . strlen($event['location'] ?? '') . ")</li>";echo "<table border='1'>";

    echo "<li><strong>name:</strong> '" . ($event['name'] ?? 'NULL') . "' (length: " . strlen($event['name'] ?? '') . ")</li>";echo "<tr><th>Column</th><th>Type</th><th>Null</th><th>Default</th></tr>";

    echo "</ul>";foreach ($columns as $col) {

} else {    echo "<tr>";

    echo "<p style='color: red;'>Event not found!</p>";    echo "<td>{$col['Field']}</td>";

}    echo "<td>{$col['Type']}</td>";

    echo "<td>{$col['Null']}</td>";

// Show available sports from database    echo "<td>{$col['Default']}</td>";

echo "<hr><h3>Available Sports from Database:</h3>";    echo "</tr>";

$sports_stmt = $pdo->prepare("SELECT sport_name FROM figure_sports WHERE is_active = 1 ORDER BY sport_name");}

$sports_stmt->execute();echo "</table>";

$available_sports = $sports_stmt->fetchAll(PDO::FETCH_COLUMN);?>

if (empty($available_sports)) {
    echo "<p style='color: red;'>No sports found!</p>";
} else {
    echo "<ul>";
    foreach ($available_sports as $sport) {
        $matches = ($event['sport_discipline'] ?? '') === $sport;
        echo "<li><strong>$sport</strong>" . ($matches ? " ← MATCHES EVENT" : "") . "</li>";
    }
    echo "</ul>";
}

// Show available formats
echo "<hr><h3>Available Scoring Formats:</h3>";
$formats_stmt = $pdo->prepare("
    SELECT sf.format_id, sf.name, sf.sport, sf.is_active
    FROM scoring_formats sf
    WHERE sf.is_active = 1
    ORDER BY sf.sport, sf.name
    LIMIT 20
");
$formats_stmt->execute();
$scoring_formats = $formats_stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($scoring_formats)) {
    echo "<p style='color: red;'>No scoring formats found!</p>";
} else {
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Format ID</th><th>Name</th><th>Sport</th><th>Matches Event</th></tr>";
    foreach ($scoring_formats as $format) {
        $matches = ($event['scoring_format'] ?? '') == $format['format_id'];
        echo "<tr" . ($matches ? " style='background: yellow;'" : "") . ">";
        echo "<td>{$format['format_id']}</td>";
        echo "<td>" . htmlspecialchars($format['name']) . "</td>";
        echo "<td>" . htmlspecialchars($format['sport']) . "</td>";
        echo "<td>" . ($matches ? "YES" : "no") . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Test the PHP selection logic
if ($event) {
    echo "<hr><h3>PHP Selection Logic Test:</h3>";
    
    echo "<h4>Sport Selection:</h4>";
    foreach ($available_sports as $sport) {
        $isSelected = ($event['sport_discipline'] ?? '') === $sport;
        echo "<div>Sport: '$sport' === Event: '{$event['sport_discipline']}' = " . ($isSelected ? "TRUE" : "false") . "</div>";
    }
    
    echo "<h4>Format Selection:</h4>";
    foreach (array_slice($scoring_formats, 0, 5) as $format) {
        $isSelected = ($event['scoring_format'] ?? '') == $format['format_id'];
        echo "<div>Format: '{$format['format_id']}' == Event: '{$event['scoring_format']}' = " . ($isSelected ? "TRUE" : "false") . "</div>";
    }
}

echo "<hr><p><a href='event_edit.php?id=$event_id'>Edit This Event</a></p>";
?>