<?php
require_once '../includes/db.php';

$event_id = 3;

echo "=== CHECKING REPORT CONFIGURATIONS FOR EVENT $event_id ===\n\n";

// Check what the dynamic dashboard would show
$sql = "SELECT id, name, view_type, event_id, heat_number, category, status, created_at 
        FROM result_configurations 
        WHERE event_id = ? AND status = 'active'
        ORDER BY view_type, heat_number, name";

$stmt = $pdo->prepare($sql);
$stmt->execute([$event_id]);
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Total active configurations: " . count($configs) . "\n\n";

$by_type = [];
foreach ($configs as $config) {
    $by_type[$config['view_type']][] = $config;
}

foreach ($by_type as $type => $configs) {
    echo strtoupper($type) . " (" . count($configs) . " configs):\n";
    foreach ($configs as $config) {
        $heat_text = $config['heat_number'] ? "Heat {$config['heat_number']}" : "All heats";
        $category_text = $config['category'] ? "Category: {$config['category']}" : "All categories";
        echo "  - ID {$config['id']}: {$config['name']} ($heat_text, $category_text)\n";
    }
    echo "\n";
}

// Also check if there are any inactive ones
$sql_inactive = "SELECT COUNT(*) as count FROM result_configurations WHERE event_id = ? AND status != 'active'";
$stmt_inactive = $pdo->prepare($sql_inactive);
$stmt_inactive->execute([$event_id]);
$inactive_count = $stmt_inactive->fetch(PDO::FETCH_ASSOC)['count'];

echo "Inactive configurations: $inactive_count\n";

?>
