<?php
// Test API endpoint
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../../includes/auth.php';
include '../../includes/db.php';

header('Content-Type: application/json');

try {
    // Test database connection
    $test = $pdo->query("SELECT 1")->fetch();
    
    // Check if tables exist
    $tables = [];
    try {
        $pdo->query("SELECT 1 FROM user_groups LIMIT 1");
        $tables['user_groups'] = 'exists';
    } catch (Exception $e) {
        $tables['user_groups'] = 'missing: ' . $e->getMessage();
    }
    
    try {
        $pdo->query("SELECT 1 FROM user_group_memberships LIMIT 1");
        $tables['user_group_memberships'] = 'exists';
    } catch (Exception $e) {
        $tables['user_group_memberships'] = 'missing: ' . $e->getMessage();
    }
    
    try {
        $pdo->query("SELECT 1 FROM user_profiles LIMIT 1");
        $tables['user_profiles'] = 'exists';
    } catch (Exception $e) {
        $tables['user_profiles'] = 'missing: ' . $e->getMessage();
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'API working',
        'database' => 'connected',
        'tables' => $tables,
        'action' => $_GET['action'] ?? 'none',
        'group_id' => $_GET['group_id'] ?? 'none'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
}
?>
