# BIB Distribution Manager - User Manual

## Table of Contents
1. [Overview](#overview)
2. [Getting Started](#getting-started)
3. [BIB Series Management](#bib-series-management)
4. [Participant Assignment](#participant-assignment)
5. [Reporting and Export](#reporting-and-export)
6. [Advanced Features](#advanced-features)
7. [Troubleshooting](#troubleshooting)
8. [Best Practices](#best-practices)

---

## Overview

The **BIB Distribution Manager** is a comprehensive system for managing BIB (race number) assignments for sporting events. It provides an intuitive interface for creating BIB series, assigning numbers to participants, and generating detailed reports.

### Key Features
- 🏷️ **Series Management**: Create and manage multiple BIB series with custom ranges and colors
- 👥 **Participant Assignment**: Assign BIB numbers to participants with validation and conflict detection
- 📊 **Real-time Statistics**: Visual overview of series usage and availability
- 📋 **Comprehensive Reporting**: Multiple report formats for printing and data export
- 🔄 **Auto-Assignment**: Intelligent automatic BIB assignment tools
- 📱 **Responsive Design**: Works on desktop, tablet, and mobile devices

---

## Getting Started

### Accessing the BIB Distribution Manager

1. Navigate to **Admin Dashboard** → **BIB Distribution**
2. Select an event from the dropdown menu
3. The system will load all available BIB series and participants for that event

### Interface Overview

The main interface consists of four main sections:

1. **Event Selection**: Choose which event to manage
2. **BIB Series Overview**: Visual statistics of all series
3. **Participant Assignment**: Table for assigning BIBs to participants
4. **Quick Actions**: Tools for bulk operations and reporting

---

## BIB Series Management

### Creating a New BIB Series

1. **Click "New Series"** in the BIB Series Overview header
2. **Fill in the form**:
   - **Series Name**: e.g., "Youth", "Adults", "Masters"
   - **Series Color**: Choose a color for visual identification
   - **Start Number**: First number in the range
   - **End Number**: Last number in the range
   - **Missing Numbers** (Optional): Numbers to exclude (comma-separated)
   - **Additional Numbers** (Optional): Extra numbers outside the range
   - **Description** (Optional): Brief description of the series

3. **Preview**: The system shows a real-time preview of your series
4. **Click "Create Series"** to save

### Editing an Existing Series

1. **Click "Edit"** on any series card
2. **Modify the fields** as needed
3. **Click "Update Series"** to save changes

> ⚠️ **Note**: You cannot modify ranges if there are existing BIB assignments that would be affected.

### Series Information

Each series card displays:
- **Series Name** and **Color Badge**
- **Number Range** (start - end)
- **Usage Statistics** with visual progress bar
- **Available vs. Assigned** counts
- **Quick Action Buttons**

### Series Actions

- **👁️ View Details**: Comprehensive series information modal
- **📋 Numbers**: View all available numbers in a modal
- **✏️ Edit**: Modify series settings
- **⚙️ Manage All**: Access the full series manager

---

## Participant Assignment

### Manual Assignment

1. **Locate the participant** in the assignment table
2. **Enter a BIB number** in the input field
3. **The system validates** the number in real-time:
   - ✅ **Green border**: Valid number
   - ❌ **Red border**: Invalid (duplicate, out of range, etc.)
   - ⚠️ **Yellow border**: Warning (unusual but allowed)

### Auto-Assignment Tools

#### Assign Next Available
- **Click the "↗️" button** next to any participant
- System automatically assigns the next available number from their appropriate series

#### Bulk Auto-Assignment
- **Click "Auto Assign BIBs"** in the Quick Actions section
- System assigns available numbers to all unassigned participants
- Maintains series organization and avoids conflicts

#### Clear All Assignments
- **Click "Clear All BIBs"** to remove all assignments
- Useful for starting over or testing different configurations

### Validation Features

The system automatically validates:
- **Duplicate Prevention**: No two participants can have the same BIB
- **Range Validation**: Numbers must belong to valid series ranges
- **Multi-Heat Detection**: Warns if a participant appears in multiple heats
- **Real-time Feedback**: Immediate visual indication of validation status

### Table Features

- **Sortable Columns**: Click headers to sort by Name, Current BIB, or New BIB
- **Search/Filter**: Use browser's find function (Ctrl+F) to locate specific participants
- **Color Coding**: BIB inputs are color-coded to match their series
- **Status Indicators**: Visual feedback for validation status

---

## Reporting and Export

### Print Report (Simple)

**Purpose**: Quick overview for event organizers

**Contents**:
- Assignment summary by series
- Free numbers list
- Combined overview

**Usage**:
1. Click **"Print Report"** button
2. System generates a print-ready HTML page
3. Use browser's print function

### Detailed Report (Modal)

**Purpose**: Comprehensive analysis and planning

**Features**:
- **Three Report Views**:
  1. **Assignments**: Participants grouped by series
  2. **Free Numbers**: Available numbers with manual assignment table
  3. **Combined**: Side-by-side comparison

**Usage**:
1. Click **"Detailed Report"** button
2. Navigate between tabs for different views
3. Use **"Print Report"** to print the active tab

### Export Options

#### CSV Export (Free Numbers)
- **Purpose**: Import into spreadsheets for manual management
- **Contents**: BIB Number, Participant Name (empty), Notes (empty)
- **Usage**: Click "Export CSV" on any series in the Free Numbers view

#### Copy to Clipboard
- **Purpose**: Quick data transfer to other applications
- **Usage**: Click "Copy Table" on any free numbers table
- **Format**: Tab-separated values suitable for Excel/Google Sheets

#### Series Information Export
- **Purpose**: Complete series configuration backup
- **Contents**: All series settings, statistics, and number lists
- **Usage**: Click "Export Series Info" in the Series Details modal

---

## Advanced Features

### Series Details Modal

**Access**: Click "View Details" on any series card

**Information Displayed**:
- Complete series configuration
- Usage statistics with visual progress bar
- Missing and additional numbers
- Quick access to available numbers
- Export functionality

### Available Numbers Modal

**Access**: Click "Numbers" on any series card or "View Available Numbers" in Series Details

**Features**:
- **Organized Display**: Numbers arranged in columns for easy viewing
- **Statistics Panel**: Complete usage information
- **Export Options**: Copy to clipboard or download CSV
- **Print Function**: Generate printable list

### BIB Validation System

The system performs comprehensive validation:

1. **Real-time Validation**: As you type
2. **Duplicate Detection**: Across all participants and heats
3. **Range Checking**: Ensures numbers belong to valid series
4. **Missing Number Handling**: Respects excluded numbers in series
5. **Additional Number Support**: Allows numbers outside main ranges

### Preview and Statistics

- **Live Series Statistics**: Real-time updates as assignments change
- **Usage Percentages**: Visual progress bars show series utilization
- **Color Coding**: Consistent visual identification throughout the system
- **Responsive Updates**: All displays update automatically when changes are made

---

## Troubleshooting

### Common Issues and Solutions

#### "BIB number already assigned" Error
- **Cause**: Another participant already has this number
- **Solution**: Use a different number or check for duplicates
- **Prevention**: Use the auto-assignment feature to avoid conflicts

#### "Number not in valid range" Error
- **Cause**: The number doesn't belong to any defined series
- **Solution**: Create a new series or use a number within existing ranges
- **Check**: Review series ranges in the overview section

#### "Series not found" Error
- **Cause**: No BIB series defined for the event
- **Solution**: Create at least one BIB series before assigning numbers
- **Access**: Use "New Series" or "Manage All" buttons

#### Changes Not Saving
- **Check**: Ensure you have admin privileges
- **Verify**: Check network connection
- **Retry**: Refresh the page and try again
- **Contact**: System administrator if issues persist

#### Print Reports Not Working
- **Check**: Browser popup blocker settings
- **Solution**: Allow popups for this site
- **Alternative**: Use the export functions and print from your preferred application

### Data Validation Errors

#### Range Overlap
- **Issue**: New series range overlaps with existing series
- **Solution**: Adjust start/end numbers to avoid overlap
- **Check**: Review existing series ranges before creating new ones

#### Existing Assignments Conflict
- **Issue**: Cannot modify series with active assignments
- **Solution**: Clear affected assignments first, then modify the series
- **Alternative**: Create a new series instead of modifying existing one

---

## Best Practices

### Series Organization

1. **Plan Your Series Structure**:
   - Group by age categories, skill levels, or event types
   - Use descriptive names (e.g., "Youth 12-15", "Masters 50+")
   - Choose distinct colors for easy identification

2. **Number Range Strategy**:
   - Leave gaps between series for future expansion
   - Use logical number sequences (1-100, 101-200, etc.)
   - Consider excluding unlucky numbers if culturally relevant

3. **Color Coding**:
   - Use high contrast colors for visibility
   - Maintain consistency across related events
   - Consider color blindness accessibility

### Assignment Workflow

1. **Preparation**:
   - Create all necessary series before starting assignments
   - Review participant lists for completeness
   - Plan for special requirements (team groupings, etc.)

2. **Assignment Process**:
   - Use auto-assignment for bulk operations
   - Manually assign special cases or requests
   - Validate all assignments before finalizing

3. **Quality Control**:
   - Generate detailed reports to verify assignments
   - Check for duplicate or missing assignments
   - Review series utilization for balance

### Reporting and Documentation

1. **Regular Backups**:
   - Export series information regularly
   - Generate reports at key milestones
   - Keep printed copies as backup

2. **Distribution**:
   - Print assignment lists for registration tables
   - Export data for timing system integration
   - Provide series information to announcers

3. **Communication**:
   - Share BIB assignment information with relevant staff
   - Provide clear instructions for BIB distribution
   - Document any special assignment rules or exceptions

### Event Day Preparation

1. **Final Validation**:
   - Run complete validation check before event day
   - Generate all necessary reports
   - Prepare contingency BIB numbers

2. **Staff Training**:
   - Ensure registration staff understand the BIB system
   - Provide series information and color coding guide
   - Establish procedures for handling issues

3. **Backup Plans**:
   - Keep spare BIB numbers available
   - Have manual assignment procedures ready
   - Document key system information for quick reference

---

## Technical Requirements

### System Requirements
- **Browser**: Modern web browser (Chrome, Firefox, Safari, Edge)
- **Internet**: Stable internet connection
- **Permissions**: Admin access to the event management system
- **Screen**: Minimum 1024x768 resolution recommended

### Data Storage
- All data is stored securely in the database
- Changes are saved automatically when valid
- Regular backups are recommended

### Security
- Admin authentication required
- Session management for security
- Audit trail for all changes

---

## Support and Updates

### Getting Help
- Contact your system administrator for technical issues
- Report bugs or feature requests through proper channels
- Refer to this manual for operational questions

### System Updates
- New features are added regularly
- Check for announcements about system updates
- Training may be provided for major new features

---

*Last Updated: August 18, 2025*
*Version: 2.0*

For technical support or additional training, please contact your system administrator.
