# Participant Media Fields Enhancement

## Overview
Added new media and information fields to the participants system:
- **Photo Upload**: Profile photos for participants
- **Motion Video**: Video files showing participant in motion
- **Facts Repeater**: Multiple fact entries with title and description

## Database Changes

### New Columns in `participants` table:
- `photo` VARCHAR(255) NULL - Path to participant photo file
- `motion_video` VARCHAR(255) NULL - Path to participant motion/video file

### New Table: `participant_facts`
```sql
CREATE TABLE participant_facts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    participant_id INT NOT NULL,
    title VARCHAR(255) NOT NULL,
    fact TEXT NOT NULL,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (participant_id) REFERENCES participants(id) ON DELETE CASCADE,
    INDEX idx_participant_sort (participant_id, sort_order)
);
```

## File Structure

### New Files Created:
- `install/add_participant_media_fields.sql` - Database migration script
- `install/run_migration.php` - PHP migration runner
- `admin/test_participant_fields.php` - Test file to verify changes

### Modified Files:
- `admin/participant_add.php` - Updated form with new fields

### Upload Directory:
- `uploads/participants/` - Directory for storing participant media files

## Features

### 1. Photo Upload
- **Supported formats**: JPG, JPEG, PNG, GIF, WEBP
- **Max file size**: 5MB
- **Features**: 
  - File validation
  - Image preview
  - Automatic file naming with timestamp

### 2. Motion Video Upload
- **Supported formats**: MP4, AVI, MOV, WMV, WEBM, MKV
- **Max file size**: 50MB
- **Features**:
  - File validation
  - File information display
  - Automatic file naming with timestamp

### 3. Facts Repeater Field
- **Dynamic fields**: Add/remove fact entries
- **Fields per fact**:
  - Title (e.g., "Specialty", "Achievement")
  - Description (textarea for detailed information)
  - Automatic sort ordering
- **Features**:
  - Add more facts button
  - Remove individual facts
  - Validation to prevent empty submissions

## Form Enhancements

### UI Improvements:
- Styled fact items with background and borders
- Hover effects for better UX
- File upload previews and validation
- Clear visual sections for different field types

### JavaScript Features:
- Dynamic add/remove facts functionality
- File size validation
- Image preview for photos
- Video file information display
- Form validation including new fields

## Usage

### Adding a Participant with Media:
1. Fill in standard participant information
2. **Upload Photo**: Click "Choose File" under "Participant Photo"
3. **Upload Video**: Click "Choose File" under "Motion Video"
4. **Add Facts**: 
   - Fill in fact title and description
   - Click "Add Another Fact" for more entries
   - Click trash icon to remove unwanted facts
5. Submit the form

### File Storage:
- All uploaded files are stored in `uploads/participants/`
- Files are renamed with timestamp and unique ID for security
- Database stores relative path to files

## Security Features

### File Upload Security:
- File type validation (whitelist approach)
- File size limits
- Automatic file renaming to prevent conflicts
- Upload directory outside web root access

### Database Security:
- Prepared statements for all queries
- Foreign key constraints
- Proper error handling

## Migration Notes

To apply these changes to an existing system:

1. **Run database migration**:
   ```bash
   cd install
   php run_migration.php
   ```

2. **Ensure upload directory has proper permissions**:
   ```bash
   chmod 755 uploads/participants/
   ```

3. **Update web server configuration** if needed to allow file uploads

## Testing

Use `admin/test_participant_fields.php` to verify:
- Database schema changes
- Upload directory creation
- Table structure

## Future Enhancements

Potential improvements for the future:
- Image resizing/optimization
- Video thumbnails
- Bulk media upload
- Media gallery view
- Advanced fact categorization
- Export functionality including media files
