# Heat Status Transition Matrix - Quick Reference

## Available Actions by Current Status

### 📋 **PENDING** Heat
| Action | Result Status | Button Style | Icon |
|--------|---------------|--------------|------|
| Activate Heat | → active | Success (Green) | ▶️ fa-play |
| Cancel | → cancelled | Outline Danger (Red) | ❌ fa-ban |
| Reschedule | → rescheduled | Outline Warning (Orange) | 🕒 fa-clock |

**Use Cases:**
- Initial heat setup
- Heat not yet started
- Waiting for participants

---

### 🔥 **ACTIVE** Heat (Currently Running)
| Action | Result Status | Button Style | Icon |
|--------|---------------|--------------|------|
| Finish | → finished | Primary (Blue) | ✓ fa-check |
| Set Pending | → pending | Secondary (Gray) | ⏸️ fa-pause |
| Cancel | → cancelled | Outline Danger (Red) | ❌ fa-ban |
| Reschedule | → rescheduled | Outline Warning (Orange) | 🕒 fa-clock |
| Change Run | ↔️ (same) | Success outline | ◀️ ▶️ |

**Use Cases:**
- Heat in progress
- Judges are scoring
- Live event happening

**Special Features:**
- Run navigation (Prev/Next)
- Real-time progress display
- Green border indicator

---

### ✅ **FINISHED** Heat (Completed)
| Action | Result Status | Button Style | Icon |
|--------|---------------|--------------|------|
| Reactivate | → active | Success (Green) | 🔄 fa-redo |
| Set Pending | → pending | Secondary (Gray) | ⏸️ fa-pause |

**Use Cases:**
- Heat completed normally
- All scores finalized
- Results published

**Special Features:**
- Blue border indicator
- 100% completion shown
- Can reopen for corrections

---

### ❌ **CANCELLED** Heat
| Action | Result Status | Button Style | Icon |
|--------|---------------|--------------|------|
| Activate | → active | Success (Green) | ▶️ fa-play |
| Reschedule | → rescheduled | Outline Warning (Orange) | 🕒 fa-clock |
| Set Pending | → pending | Outline Secondary (Gray) | ⏸️ fa-pause |

**Use Cases:**
- Weather cancellation
- Technical issues
- Insufficient participants
- Safety concerns

**Special Features:**
- Red border indicator
- Can resume or reschedule
- Flexible recovery options

---

### 🕒 **RESCHEDULED** Heat (Postponed)
| Action | Result Status | Button Style | Icon |
|--------|---------------|--------------|------|
| Activate | → active | Success (Green) | ▶️ fa-play |
| Cancel | → cancelled | Outline Danger (Red) | ❌ fa-ban |
| Set Pending | → pending | Outline Secondary (Gray) | ⏸️ fa-pause |

**Use Cases:**
- Time conflict
- Weather delay
- Venue issues
- Scheduling adjustments

**Special Features:**
- Orange border indicator
- Ready to activate when conditions allow
- Can cancel if unable to reschedule

---

## Status Transition Workflow Examples

### Example 1: Normal Heat Flow
```
pending → [Activate] → active → [Finish] → finished
```

### Example 2: Heat with Technical Issue
```
active → [Set Pending] → pending → (fix issue) → [Activate] → active → [Finish] → finished
```

### Example 3: Weather Delay
```
active → [Reschedule] → rescheduled → (wait for weather) → [Activate] → active → [Finish] → finished
```

### Example 4: Cancelled then Rescheduled
```
active → [Cancel] → cancelled → [Reschedule] → rescheduled → [Activate] → active → [Finish] → finished
```

### Example 5: Corrections Needed After Finish
```
finished → [Reactivate] → active → (fix scores) → [Finish] → finished
```

### Example 6: False Start / Complete Reset
```
active → [Set Pending] → pending → (reset participants) → [Activate] → active
```

---

## Complete Transition Matrix

| From ↓ / To → | pending | active | finished | cancelled | rescheduled |
|---------------|---------|--------|----------|-----------|-------------|
| **pending**   | - | ✅ | ❌ | ✅ | ✅ |
| **active**    | ✅ | - | ✅ | ✅ | ✅ |
| **finished**  | ✅ | ✅ | - | ❌ | ❌ |
| **cancelled** | ✅ | ✅ | ❌ | - | ✅ |
| **rescheduled** | ✅ | ✅ | ❌ | ✅ | - |

**Legend:**
- ✅ = Allowed transition
- ❌ = Not allowed transition
- `-` = Same status (no transition)

---

## Business Rules

### When to Use Each Status

#### Use **PENDING** when:
- Heat is configured but start time hasn't arrived
- Heat is ready but waiting for previous heats
- Heat needs configuration before activation
- Temporary pause/hold before starting

#### Use **ACTIVE** when:
- Judges are actively scoring
- Heat is currently running
- Athletes are performing
- Real-time updates needed

#### Use **FINISHED** when:
- All participants have completed their runs
- Scores are finalized and approved
- Results are ready for publication
- No more changes expected (but still possible)

#### Use **CANCELLED** when:
- Heat cannot proceed due to external factors
- Safety concerns prevent completion
- Technical issues cannot be resolved
- Not enough participants present

#### Use **RESCHEDULED** when:
- Heat needs to move to different time
- Temporary interruption with planned restart
- Calendar adjustment needed
- Waiting for specific conditions

---

## Button Color Guide

| Status | Border Color | Badge Color | Primary Action Color |
|--------|--------------|-------------|---------------------|
| pending | None (default) | Gray (bg-secondary) | Green (Activate) |
| active | Green | Yellow (bg-warning) | Blue (Finish) |
| finished | Blue | Blue (bg-info) | Green (Reactivate) |
| cancelled | Red | Red (bg-danger) | Green (Activate) |
| rescheduled | Orange | Orange (bg-warning) | Green (Activate) |

---

## API Integration Notes

### Checking Heat Status
```php
$stmt = $pdo->prepare("
    SELECT status FROM event_heat_settings 
    WHERE event_id = ? AND heat_number = ?
");
$stmt->execute([$event_id, $heat_number]);
$heat = $stmt->fetch();

if ($heat['status'] === 'active') {
    // Allow scoring
} else {
    // Block scoring, show appropriate message
}
```

### Querying Heats by Status
```php
// Get all active heats
$active_heats = $pdo->prepare("
    SELECT * FROM event_heat_settings 
    WHERE event_id = ? AND status = 'active'
");

// Get heats that can be scored (active only)
$scorable_heats = $pdo->prepare("
    SELECT * FROM event_heat_settings 
    WHERE status = 'active'
");

// Get incomplete heats (not finished)
$incomplete = $pdo->prepare("
    SELECT * FROM event_heat_settings 
    WHERE status IN ('pending', 'active', 'rescheduled')
");
```

---

**Version**: 2.0  
**Last Updated**: November 2025  
**System**: StyleScore Heat Management
