# Heat Bracket System Architecture

```
┌─────────────────────────────────────────────────────────────────────┐
│                         CLIENT INTERFACES                            │
├─────────────────────────────┬───────────────────────────────────────┤
│   Judge Score Panel         │   Admin Heat Config                   │
│   (score.php)               │   (admin_heat_config.php)             │
│                             │                                       │
│   - No Active Heat Overlay  │   - Full Bracket Grid                 │
│   - Compact Bracket View    │   - Heat Management                   │
│   - Auto-refresh every 10s  │   - Flow Configuration                │
└──────────────┬──────────────┴──────────────┬────────────────────────┘
               │                             │
               │ AJAX Request                │ AJAX Request
               │ ?event_id=1&compact=1       │ ?event_id=1&compact=0
               │                             │
               ▼                             ▼
┌─────────────────────────────────────────────────────────────────────┐
│                      API ENDPOINT                                    │
│                 heat_bracket_view_api.php                            │
│                                                                      │
│  1. Validate Parameters (event_id, compact mode)                    │
│  2. Query Database (heats + participants)                           │
│  3. Build Bracket Levels                                            │
│  4. Generate Connections                                            │
│  5. Select Template (compact vs full)                               │
│  6. Return JSON Response                                            │
└──────────────┬──────────────────────────────┬────────────────────────┘
               │                              │
               │ include compact              │ include full
               ▼                              ▼
┌──────────────────────────────┐  ┌─────────────────────────────┐
│  heat_bracket_compact.php    │  │  heat_bracket_full.php      │
│                              │  │                             │
│  • 180px cards               │  │  • Full-size cards          │
│  • Minimal info              │  │  • Participant lists        │
│  • Status badges             │  │  • Flow badges              │
│  • SVG connections           │  │  • Time info                │
│  • onclick handlers          │  │  • Action buttons           │
└──────────────┬───────────────┘  └─────────────┬───────────────┘
               │                                │
               └────────────┬───────────────────┘
                           ▼
┌─────────────────────────────────────────────────────────────────────┐
│                      JSON RESPONSE                                   │
│  {                                                                   │
│    "success": true,                                                  │
│    "html": "<div class='bracket-flow-container'>...</div>",         │
│    "connections": [{"from": 1, "to": 5}, ...],                      │
│    "bracket_levels": [[1,2,3,4], [5,6], [7]]                        │
│  }                                                                   │
└──────────────┬──────────────────────────────────────────────────────┘
               │
               │ JavaScript processes response
               ▼
┌─────────────────────────────────────────────────────────────────────┐
│                   CLIENT-SIDE RENDERING                              │
│                                                                      │
│  1. container.innerHTML = data.html                                 │
│  2. drawBracketConnections(data.connections)                        │
│  3. Attach event handlers                                           │
│  4. Store data in window.heatBracketData                            │
└─────────────────────────────────────────────────────────────────────┘


DATABASE STRUCTURE:
══════════════════════════════════════════════════════════════════════

┌─────────────────────────┐
│  event_heat_settings    │
├─────────────────────────┤
│ heat_number (PK)        │─┐
│ heat_name               │ │
│ flow_source_heat        │ │  Defines bracket structure
│ is_active               │ │  e.g., "5" or ["1","2"]
│ active_run              │ │
│ runs_count              │ │
└─────────────────────────┘ │
                            │
                            │ Referenced by
                            │ flow_source_heat
┌─────────────────────────┐ │
│  event_participants     │ │
├─────────────────────────┤ │
│ heat_number (FK)        │─┘
│ participant_id (FK)     │─┐
│ bib_number              │ │
│ sort_order              │ │
└─────────────────────────┘ │
                            │
                            │ JOIN
┌─────────────────────────┐ │
│  participants           │ │
├─────────────────────────┤ │
│ id (PK)                 │─┘
│ first_name              │
│ last_name               │
│ country                 │
└─────────────────────────┘


BRACKET LEVEL ALGORITHM:
══════════════════════════════════════════════════════════════════════

Step 1: Find Starting Heats
┌─────────────────────────────────────────────────────┐
│ SELECT heats WHERE flow_source_heat IS NULL         │
│ These become Level 0 (QUALIFYING)                   │
└─────────────────────────────────────────────────────┘
              │
              ▼
┌───────────────────────────────────────────────────────────┐
│ Level 0: [Heat 1, Heat 2, Heat 3, Heat 4]                 │
└───────────────────────────────────────────────────────────┘

Step 2: Find Next Level
┌─────────────────────────────────────────────────────────────┐
│ For each remaining heat:                                    │
│   If flow_source_heat points to heat(s) in current level:  │
│     Add to next level                                       │
└─────────────────────────────────────────────────────────────┘
              │
              ▼
┌───────────────────────────────────────────────────────────┐
│ Level 1: [Heat 5, Heat 6]  (flow from Level 0)            │
└───────────────────────────────────────────────────────────┘

Step 3: Repeat Until No More Heats
              │
              ▼
┌───────────────────────────────────────────────────────────┐
│ Level 2: [Heat 7]  (FINAL, flows from Level 1)            │
└───────────────────────────────────────────────────────────┘


VISUAL BRACKET STRUCTURE:
══════════════════════════════════════════════════════════════════════

  QUALIFYING         ROUND 2            FINAL
  ══════════         ═══════            ═════
  
  ┌────────┐
  │ Heat 1 │─────┐
  └────────┘     │
                 ├──────┐  ┌────────┐
  ┌────────┐     │       └──│ Heat 5 │──┐
  │ Heat 2 │─────┘          └────────┘  │
  └────────┘                            │
                                        ├────┐  ┌────────┐
  ┌────────┐                            │     └──│ Heat 7 │
  │ Heat 3 │─────┐                      │        └────────┘
  └────────┘     │                      │
                 ├──────┐  ┌────────┐   │
  ┌────────┐     │       └──│ Heat 6 │──┘
  │ Heat 4 │─────┘          └────────┘
  └────────┘


SVG CONNECTION DRAWING:
══════════════════════════════════════════════════════════════════════

Heat 1 (200, 100)                    Heat 5 (400, 150)
    └─────────────────────────────────────→

Path Construction:
1. Start: fromX = 200 (right edge of Heat 1)
           fromY = 100 (vertical center)

2. Junction: midX = (200 + 400) / 2 = 300
             Draw horizontal line to (300, 100)
             Draw vertical line to (300, 150)

3. End: toX = 400 (left edge of Heat 5)
        toY = 150 (vertical center)
        Draw horizontal line to (400, 150)

SVG Path: M 200 100 L 300 100 L 300 150 L 400 150

Result: Bracket-style connection with right-angle junctions


DATA FLOW EXAMPLE:
══════════════════════════════════════════════════════════════════════

Request:
  GET /api/heat_bracket_view_api.php?event_id=1&compact=1

Database Query:
  SELECT heat_number, heat_name, flow_source_heat, is_active, ...
  FROM event_heat_settings WHERE event_id = 1

Database Result:
  heat_number | heat_name  | flow_source_heat | is_active
  ------------|------------|------------------|----------
  1           | Qual 1     | NULL             | 0
  2           | Qual 2     | NULL             | 0
  5           | Semi 1     | ["1","2"]        | 1
  7           | Final      | ["5"]            | 0

Bracket Levels Built:
  Level 0: [1, 2]
  Level 1: [5]
  Level 2: [7]

Connections Generated:
  [
    {from: 1, to: 5},
    {from: 2, to: 5},
    {from: 5, to: 7}
  ]

Template Renders:
  <div class="bracket-flow-container">
    <div class="bracket-column" data-level="0">
      <div class="bracket-column-header">QUALIFYING</div>
      <div class="bracket-heat-compact" data-heat-id="1">...</div>
      <div class="bracket-heat-compact" data-heat-id="2">...</div>
    </div>
    <div class="bracket-column" data-level="1">
      <div class="bracket-column-header">ROUND 2</div>
      <div class="bracket-heat-compact active" data-heat-id="5">
        <div class="bracket-heat-live-badge">LIVE Run 1</div>
        ...
      </div>
    </div>
    ...
  </div>

JSON Response:
  {
    "success": true,
    "html": "...",
    "connections": [...],
    "bracket_levels": [[1,2], [5], [7]]
  }

Client Renders:
  1. Inserts HTML into DOM
  2. Draws SVG connections
  3. Stores data in window.heatBracketData
  4. Attaches onclick handlers
```
