<?php
session_start();
require '../includes/db.php';

if (!isset($_SESSION['user']) || $_SESSION['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

$event_id = (int)($data['event_id'] ?? 0);
$heat_number = (int)($data['heat_number'] ?? 0);
$participant_ids = $data['participant_ids'] ?? [];

if (!$event_id || !$heat_number || !is_array($participant_ids)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid input']);
    exit;
}

try {
    foreach ($participant_ids as $participant_id) {
        $bip_check = $pdo->prepare("
            SELECT COUNT(*) FROM event_participants ep
            JOIN participants p ON ep.participant_id = p.id
            WHERE ep.event_id = ? AND ep.heat_number = ? AND p.bip = (
                SELECT bip FROM participants WHERE id = ?
            )
        ");
        $bip_check->execute([$event_id, $heat_number, $participant_id]);
        if ($bip_check->fetchColumn() == 0) {
            $stmt = $pdo->prepare("INSERT INTO event_participants (event_id, participant_id, heat_number) VALUES (?, ?, ?)");
            $stmt->execute([$event_id, $participant_id, $heat_number]);
        }
    }

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>