<?php
require '../includes/db.php';
$event_id = $_GET['event_id'] ?? 0;
$heat_number = $_GET['heat_number'] ?? '';

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="heat_assignments.csv"');
$output = fopen('php://output', 'w');
fputcsv($output, ['Heat', 'BIP', 'First Name', 'Last Name', 'Club', 'Category']);

$query = "
    SELECT ep.heat_number, p.bip, p.first_name, p.last_name, p.club, p.category
    FROM event_participants ep
    JOIN participants p ON ep.participant_id = p.id
    WHERE ep.event_id = ?
";
$params = [$event_id];

if ($heat_number !== '') {
    $query .= " AND ep.heat_number = ?";
    $params[] = $heat_number;
}

$query .= " ORDER BY ep.heat_number ASC, ep.sort_order ASC";
$stmt = $pdo->prepare($query);
$stmt->execute($params);

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    fputcsv($output, $row);
}
fclose($output);
?>