<?php
// Test the getEventData API endpoint directly
header('Content-Type: text/plain');

try {
    echo "=== Testing getEventData API Endpoint ===\n\n";
    
    // Simulate the API call
    $_GET['action'] = 'get_event_data';
    $_GET['judge_id'] = '1';
    $_GET['event_id'] = '3';
    
    // Start output buffering to capture API response
    ob_start();
    include 'api/judge_score_api_fixed.php';
    $response = ob_get_clean();
    
    echo "API Response:\n";
    echo $response . "\n\n";
    
    // Try to parse as JSON
    $data = json_decode($response, true);
    if ($data) {
        echo "Parsed response:\n";
        if (isset($data['data']['figures_data'])) {
            echo "Figures data found:\n";
            echo "Available: " . ($data['data']['figures_data']['available'] ? 'true' : 'false') . "\n";
            echo "Categories: " . implode(', ', $data['data']['figures_data']['categories'] ?? []) . "\n";
            echo "Items by category: " . print_r($data['data']['figures_data']['items_by_category'] ?? [], true) . "\n";
            if (isset($data['data']['figures_data']['debug'])) {
                echo "Debug info: " . print_r($data['data']['figures_data']['debug'], true) . "\n";
            }
        } else {
            echo "No figures_data found in response\n";
        }
    } else {
        echo "Could not parse response as JSON\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
?>
