<?php
if(!isset($_SESSION)) { session_start(); }

// If already logged in, redirect to appropriate dashboard
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    if ($_SESSION['user_type'] === 'admin') {
        header("Location: /v2/admin/dashboard.php");
    } elseif ($_SESSION['user_type'] === 'judge') {
        header("Location: /v2/judge/dashboard.php");
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - StyleScore</title>
    <?php include_once 'includes/stylesheets.php'; ?>
<!-- style skin holder -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-container {
            max-width: 400px;
            width: 100%;
            margin: 20px;
        }
        
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
        }
        
        .login-body {
            padding: 40px 30px;
        }
        
        .form-control, .form-select {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 15px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.15);
            background: white;
        }
        
        .form-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 8px;
        }
        
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 12px;
            padding: 15px;
            font-weight: 600;
            font-size: 16px;
            width: 100%;
            transition: all 0.3s ease;
            color: white;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            padding: 15px;
        }
        
        .back-link {
            color: white;
            text-decoration: none;
            font-size: 14px;
            opacity: 0.8;
            transition: opacity 0.3s ease;
        }
        
        .back-link:hover {
            opacity: 1;
            color: white;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="border-0 shadow-none card login-card">
            <div class="login-header">
                <h1 class="h3 mb-3">
                    <i class="bi bi-trophy-fill me-2"></i>
                    StyleScore
                </h1>
                <p class="mb-0 opacity-75">Sign in to continue</p>
            </div>
            
            <div class="login-body">
                <?php if (isset($_GET['error'])): ?>
                    <div class="alert alert-danger mb-4" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                        <?php
                        switch($_GET['error']) {
                            case 'missing_fields':
                                echo 'Please fill in all fields.';
                                break;
                            case 'invalid_credentials':
                                echo 'Invalid username or password.';
                                break;
                            case 'unauthorized':
                                echo 'You are not authorized to access that page.';
                                break;
                            default:
                                echo 'An error occurred. Please try again.';
                        }
                        ?>
                    </div>
                <?php endif; ?>

                <?php if (isset($_GET['message']) && $_GET['message'] === 'logged_out'): ?>
                    <div class="alert alert-success mb-4" role="alert">
                        <i class="bi bi-check-circle-fill me-2"></i>
                        You have been successfully logged out.
                    </div>
                <?php endif; ?>

                <form method="POST" action="/v2/includes/process_login.php">
                    <div class="mb-4">
                        <label for="user_type" class="form-label">
                            <i class="bi bi-person-badge me-1"></i>
                            User Type
                        </label>
                        <select class="form-select" id="user_type" name="user_type" required>
                            <option value="">Choose your role...</option>
                            <option value="admin">Administrator</option>
                            <option value="judge">Judge</option>
                        </select>
                    </div>
                    
                    <div class="mb-4">
                        <label for="username" class="form-label">
                            <i class="bi bi-person me-1"></i>
                            Username
                        </label>
                        <input type="text" class="form-control" id="username" name="username" 
                               placeholder="Enter your username" required>
                    </div>
                    
                    <div class="mb-4">
                        <label for="password" class="form-label">
                            <i class="bi bi-lock me-1"></i>
                            Password
                        </label>
                        <input type="password" class="form-control" id="password" name="password" 
                               placeholder="Enter your password" required>
                    </div>

                    <button type="submit" class="btn btn-login">
                        <i class="bi bi-box-arrow-in-right me-2"></i>
                        Sign In
                    </button>
                </form>
                
                <div class="text-center mt-4">
                    <a href="/v2/" class="back-link">
                        <i class="bi bi-arrow-left me-1"></i>
                        Back to Home
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>