<?php
/**
 * Demo Panels API - Get scoring format data
 */
require_once 'config.php';

header('Content-Type: application/json');

// Get format ID from request
$formatId = $_GET['format_id'] ?? $_POST['format_id'] ?? null;

if (!$formatId) {
    sendError('Format ID is required');
}

try {
    // Get format data
    $format = getFormatData($pdo, $formatId);
    if (!$format) {
        sendError('Scoring format not found', 404);
    }
    
    // Get additional format details
    $criteria = getFormatCriteria($pdo, $formatId);
    $diversityRules = getFormatDiversityRules($pdo, $formatId);
    $modeConfig = getFormatModeConfig($pdo, $formatId);
    $figures = getSportFigures($pdo, $format['sport']);
    
    // Get panel file for this format
    $panelFile = getPanelFile($formatId);
    
    $response = [
        'format' => $format,
        'criteria' => $criteria,
        'diversity_rules' => $diversityRules,
        'mode_config' => $modeConfig,
        'figures' => $figures,
        'panel_file' => $panelFile,
        'demo_event' => $GLOBALS['DEMO_EVENT_DATA'],
        'demo_participants' => $GLOBALS['DEMO_PARTICIPANTS']
    ];
    
    sendSuccess($response);
    
} catch (Exception $e) {
    sendError('Database error: ' . $e->getMessage(), 500);
}
?>
