<?php
include 'db.php';

echo "Adding missing created_at column to user_group_memberships table...\n\n";

try {
    // Add created_at column as alias for joined_at for consistency
    $pdo->exec("ALTER TABLE user_group_memberships ADD COLUMN created_at timestamp DEFAULT CURRENT_TIMESTAMP");
    echo "✓ Added created_at column to user_group_memberships table\n";
    
    // Update existing records to copy joined_at to created_at
    $pdo->exec("UPDATE user_group_memberships SET created_at = joined_at WHERE created_at IS NULL");
    echo "✓ Updated existing records with created_at values\n";
    
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "✓ created_at column already exists in user_group_memberships table\n";
    } else {
        echo "Error: " . $e->getMessage() . "\n";
    }
}

// Verify the column was added
try {
    $stmt = $pdo->query('DESCRIBE user_group_memberships');
    echo "\nuser_group_memberships table structure:\n";
    while ($row = $stmt->fetch()) {
        echo "  " . $row['Field'] . " - " . $row['Type'] . "\n";
    }
} catch (Exception $e) {
    echo "Error checking table: " . $e->getMessage() . "\n";
}

echo "\nColumn addition completed!\n";
?>
