<?php
echo "Starting database test...\n";

try {
    echo "About to test database connection...\n";
    
    $host = 'localhost';
    $db = 'freestyle_db';
    $user = 'root';
    $pass = '';
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";
    
    echo "Attempting PDO connection with DSN: $dsn\n";
    
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Database connection successful!\n";
    
    // Test a simple query
    $stmt = $pdo->query("SELECT 1 as test");
    $result = $stmt->fetch();
    echo "Test query result: " . $result['test'] . "\n";
    
} catch (PDOException $e) {
    echo "PDO Error: " . $e->getMessage() . "\n";
    echo "Error Code: " . $e->getCode() . "\n";
} catch (Exception $e) {
    echo "General Error: " . $e->getMessage() . "\n";
} catch (Throwable $e) {
    echo "Fatal Error: " . $e->getMessage() . "\n";
}

echo "Test complete.\n";
?>
