<?php
// Simple database connection test
try {
    include '../includes/db.php';
    echo "Database connection: OK\n";
    
    // Check if report_configurations table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'report_configurations'");
    if ($stmt->rowCount() > 0) {
        echo "Table 'report_configurations' exists\n";
        
        // Check table structure
        $stmt = $pdo->query("DESCRIBE report_configurations");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "Table columns:\n";
        foreach ($columns as $column) {
            echo "  - {$column['Field']} ({$column['Type']})\n";
        }
        
        // Count total records
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM report_configurations");
        $count = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "Total records: {$count['count']}\n";
        
        // Test query with event_id = 3
        $stmt = $pdo->prepare("SELECT id, name, view_type, category, heat_number FROM report_configurations WHERE event_id = ?");
        $stmt->execute([3]);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "Records for event_id = 3: " . count($results) . "\n";
        
        if (count($results) > 0) {
            echo "Sample records:\n";
            foreach ($results as $record) {
                echo "  - ID: {$record['id']}, Name: {$record['name']}, Type: {$record['view_type']}\n";
            }
        }
        
    } else {
        echo "Table 'report_configurations' does NOT exist\n";
        
        // Show all tables
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "Available tables:\n";
        foreach ($tables as $table) {
            echo "  - $table\n";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
?>
