<?php
include '../includes/auth.php';
include '../includes/db.php';

// Test page for notification system
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notification System Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container-fluid container-StyleScore p-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="border-0 shadow-none card">
                    <div class="border-0 shadow-none card-header">
                        <h4 class="mb-0">
                            <i class="fas fa-bell me-2"></i>
                            Notification System Test
                        </h4>
                    </div>
                    <div class="border-0 shadow-none card-body">
                        <p class="text-muted mb-4">Test the global notification system with different categories and types.</p>
                        
                        <!-- Test Buttons -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <h6>General Notifications</h6>
                                <button class="btn btn-info btn-sm mb-2 w-100" onclick="testNotification('info', 'System Info', 'This is an information message', 'general')">
                                    <i class="fas fa-info-circle me-1"></i> Test Info
                                </button>
                                <button class="btn btn-success btn-sm mb-2 w-100" onclick="testNotification('success', 'Success Message', 'Operation completed successfully', 'general')">
                                    <i class="fas fa-check-circle me-1"></i> Test Success
                                </button>
                                <button class="btn btn-warning btn-sm mb-2 w-100" onclick="testNotification('warning', 'Warning Alert', 'This is a warning message', 'system')">
                                    <i class="fas fa-exclamation-triangle me-1"></i> Test Warning
                                </button>
                                <button class="btn btn-danger btn-sm mb-2 w-100" onclick="testNotification('danger', 'Error Alert', 'This is an error message', 'system')">
                                    <i class="fas fa-times-circle me-1"></i> Test Error
                                </button>
                            </div>
                            <div class="col-md-6">
                                <h6>Competition Notifications</h6>
                                <button class="btn btn-primary btn-sm mb-2 w-100" onclick="testParticipantNotification()">
                                    <i class="fas fa-user me-1"></i> Test Participant
                                </button>
                                <button class="btn btn-warning btn-sm mb-2 w-100" onclick="testJudgeNotification()">
                                    <i class="fas fa-gavel me-1"></i> Test Judge
                                </button>
                                <button class="btn btn-danger btn-sm mb-2 w-100" onclick="testHeatNotification()">
                                    <i class="fas fa-fire me-1"></i> Test Heat
                                </button>
                                <button class="btn btn-info btn-sm mb-2 w-100" onclick="testScoringNotification()">
                                    <i class="fas fa-trophy me-1"></i> Test Scoring
                                </button>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <!-- Quick Functions Test -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <h6>Quick Functions</h6>
                                <button class="btn btn-outline-success btn-sm mb-2 w-100" onclick="notifySuccess('Quick Success', 'Using global function')">
                                    Quick Success
                                </button>
                                <button class="btn btn-outline-danger btn-sm mb-2 w-100" onclick="notifyError('Quick Error', 'Using global function')">
                                    Quick Error
                                </button>
                                <button class="btn btn-outline-warning btn-sm mb-2 w-100" onclick="notifyWarning('Quick Warning', 'Using global function')">
                                    Quick Warning
                                </button>
                                <button class="btn btn-outline-info btn-sm mb-2 w-100" onclick="notifyInfo('Quick Info', 'Using global function')">
                                    Quick Info
                                </button>
                            </div>
                            <div class="col-md-6">
                                <h6>Competition Functions</h6>
                                <button class="btn btn-outline-primary btn-sm mb-2 w-100" onclick="testCompetitionFunctions()">
                                    Test Competition Functions
                                </button>
                                <button class="btn btn-outline-danger btn-sm mb-2 w-100" onclick="notifyEmergencyStop()">
                                    Emergency Stop
                                </button>
                                <button class="btn btn-outline-secondary btn-sm mb-2 w-100" onclick="clearAllNotifications()">
                                    Clear All Notifications
                                </button>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <!-- Event ID Info -->
                        <div class="alert alert-info">
                            <strong>Current Event ID:</strong> <?php echo htmlspecialchars($notification_event_id ?? 'Not set'); ?><br>
                            <strong>User ID:</strong> <?php echo htmlspecialchars($notification_user_id); ?><br>
                            <strong>User Role:</strong> <?php echo htmlspecialchars($notification_user_role); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function testNotification(type, title, message, category) {
            if (typeof sendNotification === 'function') {
                sendNotification(type, title, message, category);
            } else {
                alert('Notification system not loaded yet. Please wait a moment and try again.');
            }
        }
        
        function testParticipantNotification() {
            if (typeof notifyParticipant === 'function') {
                const actions = ['on_start', 'started', 'completed', 'next'];
                const action = actions[Math.floor(Math.random() * actions.length)];
                const bib = Math.floor(Math.random() * 100) + 1;
                notifyParticipant(action, bib, `Test Participant ${bib}`);
            } else {
                testNotification('success', 'Participant #123 Started', 'Test participant has begun their performance', 'participant');
            }
        }
        
        function testJudgeNotification() {
            if (typeof notifyJudge === 'function') {
                notifyJudge('Score Submitted', 'Judge has submitted scores for participant #123');
            } else {
                testNotification('warning', 'Judge Action', 'Judge has submitted scores for participant #123', 'judge');
            }
        }
        
        function testHeatNotification() {
            if (typeof notifyHeat === 'function') {
                const action = Math.random() > 0.5 ? 'activated' : 'deactivated';
                const heat = Math.floor(Math.random() * 10) + 1;
                notifyHeat(action, heat, action === 'activated' ? 1 : null);
            } else {
                testNotification('danger', 'Heat 1 Activated', 'Competition is now live', 'heat');
            }
        }
        
        function testScoringNotification() {
            if (typeof notifyScore === 'function') {
                const bib = Math.floor(Math.random() * 100) + 1;
                const score = (Math.random() * 100).toFixed(1);
                notifyScore(bib, score, 'Judge A');
            } else {
                testNotification('info', 'Score Updated', 'New score recorded for participant #123', 'scoring');
            }
        }
        
        function testCompetitionFunctions() {
            const functions = [
                () => notifyParticipant('on_start', 42, 'John Doe'),
                () => notifyHeat('activated', 1, 1),
                () => notifyJudge('Score Review', 'Judge reviewing scores for heat 1'),
                () => notifyScore(42, '87.5', 'Judge B')
            ];
            
            // Execute a random function
            const randomFunc = functions[Math.floor(Math.random() * functions.length)];
            try {
                randomFunc();
            } catch (error) {
                console.error('Error executing function:', error);
                testNotification('warning', 'Function Test', 'Some competition functions may not be available yet', 'technical');
            }
        }
        
        // Log when notification system is ready
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                if (typeof globalNotificationManager !== 'undefined' && globalNotificationManager) {
                    console.log('Notification system loaded successfully');
                    testNotification('success', 'Notification System Ready', 'All notification features are now available', 'system');
                } else {
                    console.warn('Notification system not loaded');
                }
            }, 2000);
        });
    </script>
    
    <?php
    // Render notification system if available
    if (function_exists('render_notification_system')) {
        render_notification_system();
    }
    ?>
</body>
</html>
