<?php
require_once '../includes/db.php';

echo "Testing the fixed manageGroupMembers query...\n\n";

try {
    // Test the users query that was failing
    $group_id = 1; // Use a test group ID
    
    $available_users_stmt = $pdo->prepare("
        SELECT 
            u.id,
            u.username,
            p.full_name
        FROM users u
        LEFT JOIN user_profiles p ON u.id = p.user_id
        WHERE u.id NOT IN (
            SELECT user_id FROM user_group_memberships WHERE group_id = ?
        )
        ORDER BY p.full_name, u.username
        LIMIT 50
    ");
    
    $available_users_stmt->execute([$group_id]);
    $available_users = $available_users_stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "✓ Query executed successfully!\n";
    echo "Found " . count($available_users) . " available users to add to group.\n\n";
    
    if (count($available_users) > 0) {
        echo "Sample users:\n";
        foreach (array_slice($available_users, 0, 5) as $user) {
            $display_name = $user['full_name'] ?: $user['username'];
            echo "  - {$display_name} (@{$user['username']})\n";
        }
    }
    
    echo "\n✅ The manageGroupMembers query is now fixed!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
