<?php
header('Content-Type: application/json');
require_once '../includes/db.php';

try {
    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['sport']) || empty($input['sport'])) {
        echo json_encode([]);
        exit;
    }
    
    $sport = $input['sport'];
    
    // Fetch figure groups for the selected sport
    $query = $pdo->prepare("
        SELECT DISTINCT fc.category_name, fc.sport_name
        FROM figure_categories fc
        WHERE fc.sport_name = ? AND fc.is_active = 1
        ORDER BY fc.sort_order, fc.category_name
    ");
    
    $query->execute([$sport]);
    $figureGroups = $query->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($figureGroups);
    
} catch (PDOException $e) {
    error_log("Error fetching figure groups: " . $e->getMessage());
    echo json_encode([]);
} catch (Exception $e) {
    error_log("General error in get_figure_groups.php: " . $e->getMessage());
    echo json_encode([]);
}
?>
