<?php
/**
 * Event Actions Menu - Reusable component for event management
 * Can be included in any event management page
 * 
 * Required variables:
 * - $event_id: The ID of the event (optional if using localStorage)
 * 
 * Optional variables:
 * - $show_header: Whether to show the card header (default: true)
 * - $card_classes: Additional CSS classes for the card (default: 'border-0 shadow-sm')
 * - $show_public_view: Whether to show the public view button in header (default: true)
 * - $use_localStorage: Whether to load event_id from localStorage (default: false)
 */

// Set default values for optional variables
$show_header = $show_header ?? true;
$card_classes = $card_classes ?? 'border-0 shadow-sm';
$show_public_view = $show_public_view ?? true;
$use_localStorage = $use_localStorage ?? false;

// Generate unique ID for this menu instance
$menu_id = 'event-actions-menu-' . uniqid();
?>
        <?php
// Set up required variables
//$current_user = $_SESSION; // Your user data
//$event_id = $_GET['event_id'] ?? null;

// Optional configuration
$show_token_balance = true;
$show_event_selector = true;
$use_localStorage = true;
$navbar_theme = 'dark'; // or 'light'

// Include the navbar
include 'navbar_fixed.php';
?>
<div class="border-0 shadow-none card <?= $card_classes ?> bg-transparent shadow-none" id="<?= $menu_id ?>">
    <?php if ($show_header): ?>
    <div class="border-0 shadow-none card-header d-flex justify-content-between align-items-center">
        <small class="text-uppercase fw-bold"><i data-lucide="zap" class="me-1"></i>Quick Actions</small>
        <?php if ($show_public_view): ?>
        <?php if ($use_localStorage): ?>
        <a href="#" class="btn btn-sm btn-outline-primary" onclick="openPublicView()">
            <i data-lucide="eye" class="me-1"></i>Public View
        </a>
        <?php else: ?>
        <a href="public_event_dashboard.php?event_id=<?= $event_id ?>" target="_blank" class="btn btn-sm btn-outline-primary">
            <i data-lucide="eye" class="me-1"></i>Public View
        </a>
        <?php endif; ?>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    <div class="border-0 shadow-none card-body p-1">
        <div class="d-flex flex-wrap gap-1 justify-content-center">
            <?php if ($use_localStorage): ?>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="event_dashboard">
                <i data-lucide="edit" class="me-1"></i>Event Dashboard
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="edit">
                <i data-lucide="edit" class="me-1"></i>Edit Event
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="participants">
                <i data-lucide="users" class="me-1"></i>Manage Participants
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="categories">
                <i data-lucide="tags" class="me-1"></i>Sport Categories
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="judges">
                <i data-lucide="gavel" class="me-1"></i>Judge Assignments
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="head-judge">
                <i data-lucide="star" class="me-1"></i>Head Judge Panel
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="score">
                <i data-lucide="clipboard-list" class="me-1"></i>Score Event
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="scoreboard">
                <i data-lucide="trending-up" class="me-1"></i>Live Scoreboard
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="results">
                <i data-lucide="trophy" class="me-1"></i>Results Panel
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="reports">
                <i data-lucide="file-text" class="me-1"></i>Reports
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="start-list">
                <i data-lucide="users" class="me-1"></i>Open Start List
            </a>
            <a href="#" class="btn btn-sm btn-outline-primary" data-action="heat-flow">
                <i data-lucide="flame" class="me-1"></i>Heat Flow Preview
            </a>
            <?php else: ?>
            <a href="/v2/admin/event_dashboard.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary" data-action="edit">
                <i data-lucide="edit" class="me-1"></i>Event Dashboard
            </a>
            <a href="/v2/admin/event_edit.php?id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="edit" class="me-1"></i>Edit Event
            </a>
            <a href="/v2/admin/heats_configure.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="users" class="me-1"></i>Manage Participants
            </a>
            <a href="/v2/admin/event_categories.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="tags" class="me-1"></i>Sport Categories
            </a>
            <a href="/v2/admin/judge_assign.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="gavel" class="me-1"></i>Judge Assignments
            </a>
            <a href="/v2/judge/head_judge.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="star" class="me-1"></i>Head Judge Panel
            </a>
            <a href="/v2/judge/score.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="clipboard-list" class="me-1"></i>Score Event
            </a>
            <a href="/v2/admin/live_scoreboard_3.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="trending-up" class="me-1"></i>Live Scoreboard
            </a>
            <a href="/v2/admin/event_start_list.php?view_type=summary_table&event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="trophy" class="me-1"></i>Results Panel
            </a>
            <a href="/v2/judge/event_reports.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="file-text" class="me-1"></i>Reports
            </a>
            <a class="btn btn-sm btn-outline-primary" href="/v2/admin/event_start_list.php?view_type=start_list&event_id=<?= $event_id ?>">
                <i data-lucide="users" class="me-1"></i>Open Start List
            </a>
            <a href="/v2/admin/heat_flow_preview.php?event_id=<?= $event_id ?>" class="btn btn-sm btn-outline-primary">
                <i data-lucide="flame" class="me-1"></i>Heat Flow Preview
            </a>
            <?php if ($show_public_view): ?>        
                <a href="/v2/public_event_dashboard.php?event_id=<?= $event_id ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                    <i data-lucide="eye" class="me-1"></i>Public View
                </a>
            <?php endif ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if ($use_localStorage): ?>
<script>
(function() {
    // Event Actions Menu localStorage functionality
    const menuId = '<?= $menu_id ?>';
    const menu = document.getElementById(menuId);
    
    function getEventIdFromStorage() {
        return localStorage.getItem('selectedEventId') || localStorage.getItem('event_id');
    }
    
    function openPublicView() {
        const eventId = getEventIdFromStorage();
        if (eventId) {
            window.open(`public_event_dashboard.php?event_id=${eventId}`, '_blank');
        } else {
            alert('No event ID found in localStorage');
        }
    }
    
    // Make openPublicView globally available
    window.openPublicView = openPublicView;
    
    // Handle action clicks
    menu.addEventListener('click', function(e) {
        const target = e.target.closest('[data-action]');
        if (!target) return;
        
        e.preventDefault();
        const action = target.getAttribute('data-action');
        const eventId = getEventIdFromStorage();
        
        if (!eventId) {
            alert('No event ID found in localStorage');
            return;
        }
        
        let url = '';
        switch(action) {
            case 'event_dashboard':
                url = `/v2/admin/event_dashboard.php?event_id=${eventId}`;
                break;
            case 'edit':
                url = `event_edit.php?id=${eventId}`;
                break;
            case 'participants':
                url = `/v2/admin/heats_configure.php?event_id=${eventId}`;
                break;
            case 'categories':
                url = `/v2/admin/event_categories.php?event_id=${eventId}`;
                break;
            case 'judges':
                url = `/v2/admin/judge_assign.php?event_id=${eventId}`;
                break;
            case 'head-judge':
                url = `/v2/judge/head_judge.php?event_id=${eventId}`;
                break;
            case 'score':
                url = `/v2/judge/score.php?event_id=${eventId}`;
                break;
            case 'scoreboard':
                url = `/v2/admin/live_scoreboard_3.php?event_id=${eventId}`;
                break;
            case 'results':
                url = `/v2/admin/event_start_list.php?view_type=summary_table&event_id=${eventId}#results_panel`;
                break;
            case 'reports':
                url = `/v2/judge/event_reports.php?event_id=${eventId}`;
                break;
            case 'heat-flow':
                url = `/v2/admin/heat_flow_preview.php?event_id=${eventId}`;
                break;
            case 'start-list':
                url = `/v2/admin/event_start_list.php?view_type=start_list&event_id=${eventId}`;
                break;
            default:
                console.warn('Unknown action:', action);
                return;
        }
        
        if (url) {
            window.location.href = url;
        }
    });
    
    // Optional: Update menu state based on localStorage changes
    function updateMenuState() {
        const eventId = getEventIdFromStorage();
        const buttons = menu.querySelectorAll('[data-action]');
        
        buttons.forEach(button => {
            if (eventId) {
                button.classList.remove('disabled');
                button.removeAttribute('disabled');
            } else {
                button.classList.add('disabled');
                button.setAttribute('disabled', 'disabled');
            }
        });
    }
    
    // Initial state update
    updateMenuState();
    
    // Listen for localStorage changes (if needed)
    window.addEventListener('storage', function(e) {
        if (e.key === 'current_event_id' || e.key === 'event_id') {
            updateMenuState();
        }
    });
})();
</script>
<?php endif; ?>
