<?php
include '../includes/auth.php';
include '../includes/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['delete_id'])) {
        $delete_id = intval($_POST['delete_id']);
        $pdo->prepare("DELETE FROM users WHERE judge_id = ?")->execute([$delete_id]);
        $pdo->prepare("DELETE FROM judges WHERE id = ?")->execute([$delete_id]);
        $message = '<div class="alert alert-warning">Judge deleted.</div>';
    } else {
        $name = $_POST['name'];
        $is_head = isset($_POST['is_head']) ? 1 : 0;

        // Insert judge
        $stmt = $pdo->prepare("INSERT INTO judges (name, is_head) VALUES (?, ?)");
        if ($stmt->execute([$name, $is_head])) {
            $judge_id = $pdo->lastInsertId();

            // Generate login
            $username = strtolower(str_replace(' ', '_', $name)) . '_' . $judge_id;
            $password = 'judge' . rand(100, 999); // simple password for demo
            $stmt2 = $pdo->prepare("INSERT INTO users (username, password, role, judge_id)
                                    VALUES (?, ?, 'judge', ?)");
            $stmt2->execute([$username, $password, $judge_id]);

            $message = "<div class='alert alert-success'>
                Judge added.<br>Login: <strong>$username</strong><br>Password: <strong>$password</strong>
            </div>";
        } else {
            $message = '<div class="alert alert-danger">Failed to add judge.</div>';
        }
    }
}

$judges = $pdo->query("SELECT * FROM judges ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Judges</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Add New Judge</h2>
    <?php echo $message; ?>

    <div class="mb-3">
        <a href="judge_export.php?format=csv" class="btn btn-outline-primary btn-sm">Export CSV</a>
        <a href="judge_export.php?format=pdf" class="btn btn-outline-danger btn-sm">Export PDF</a>
    </div>

    <form method="post" class="mb-4">
        <div class="mb-3">
            <label class="form-label">Judge Name</label>
            <input type="text" class="form-control" name="name" required>
        </div>
        <div class="form-check mb-3">
            <input class="form-check-input" type="checkbox" name="is_head" id="is_head">
            <label class="form-check-label" for="is_head">
                Is Head Judge
            </label>
        </div>
        <button type="submit" class="btn btn-success">Add Judge</button>
    </form>

    <h4>All Judges</h4>
    <table class="table table-bordered">
        <thead>
            <tr><th>ID</th><th>Name</th><th>Head Judge</th><th>Delete</th></tr>
        </thead>
        <tbody>
            <?php foreach ($judges as $j): ?>
            <tr>
                <td><?= $j['id'] ?></td>
                <td><?= htmlspecialchars($j['name']) ?></td>
                <td><?= $j['is_head'] ? 'Yes' : 'No' ?></td>
                <td>
                    <form method="post" onsubmit="return confirm('Delete this judge?');">
                        <input type="hidden" name="delete_id" value="<?= $j['id'] ?>">
                        <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
