<?php
include '../includes/auth.php';
include '../includes/db.php';

$message = '';

// Delete handler
if (isset($_GET['delete'])) {
    $pid = intval($_GET['delete']);
    $pdo->prepare("DELETE FROM participants WHERE id = ?")->execute([$pid]);
    $message = '<div class="alert alert-danger">Participant deleted.</div>';
}

// Export handler
if (isset($_GET['export']) && in_array($_GET['export'], ['csv', 'pdf'])) {
    $stmt = $pdo->query("SELECT * FROM participants ORDER BY id DESC");
    $participants = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($_GET['export'] === 'csv') {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="participants.csv"');
        $output = fopen('php://output', 'w');
        fputcsv($output, ['BIP', 'First Name', 'Last Name', 'Gender', 'FIS Code', 'Licence Code', 'Licence Type', 'Club', 'Country', 'Date of Birth', 'Category']);
        foreach ($participants as $p) {
            fputcsv($output, [
                $p['bip'], $p['first_name'], $p['last_name'], $p['gender'], $p['fis_code'],
                $p['licence_code'], $p['licence_type'], $p['club'], $p['country'],
                $p['dob'], $p['category']
            ]);
        }
        fclose($output);
        exit;
    }

    if ($_GET['export'] === 'pdf') {
        require_once '../vendor/autoload.php';
        $pdf = new \TCPDF();
        $pdf->AddPage();
        $pdf->SetFont('helvetica', '', 9);
        $html = "<h2>Participant List</h2><table border='1' cellpadding='4'><tr>
            <th>BIP</th><th>First</th><th>Last</th><th>Gender</th><th>FIS</th><th>Licence Code</th><th>Licence Type</th>
            <th>Club</th><th>Country</th><th>DOB</th><th>Category</th></tr>";
        foreach ($participants as $p) {
            $html .= "<tr>
                <td>{$p['bip']}</td><td>{$p['first_name']}</td><td>{$p['last_name']}</td><td>{$p['gender']}</td>
                <td>{$p['fis_code']}</td><td>{$p['licence_code']}</td><td>{$p['licence_type']}</td>
                <td>{$p['club']}</td><td>{$p['country']}</td><td>{$p['dob']}</td><td>{$p['category']}</td>
            </tr>";
        }
        $html .= "</table>";
        $pdf->writeHTML($html);
        $pdf->Output('participants.pdf', 'D');
        exit;
    }
}

$participants = $pdo->query("SELECT * FROM participants ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Participants</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>td, th { font-size: 13px; }</style>
</head>
<body>
<div class="container mt-5">
    <h2>Participants</h2>
    <?php echo $message; ?>
    <div class="mb-3">
        <a href="?export=csv" class="btn btn-outline-primary btn-sm">Export CSV</a>
        <a href="?export=pdf" class="btn btn-outline-danger btn-sm">Export PDF</a>
    </div>
    <form method="post" enctype="multipart/form-data" class="mb-4">
        <label class="form-label">Import Participants (CSV):</label>
        <input type="file" name="import_file" class="form-control mb-2" required>
        <button type="submit" class="btn btn-success">Import</button>
    </form>

    <div class="table-responsive">
    <table class="table table-bordered table-sm">
        <thead>
            <tr>
                <th>ID</th><th>BIP</th><th>First</th><th>Last</th><th>Gender</th><th>FIS</th><th>Licence Code</th>
                <th>Licence Type</th><th>Club</th><th>Country</th><th>DOB</th><th>Category</th><th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($participants as $p): ?>
            <tr>
                <td><?= $p['id'] ?></td>
                <td><?= $p['bip'] ?></td>
                <td><?= htmlspecialchars($p['first_name']) ?></td>
                <td><?= htmlspecialchars($p['last_name']) ?></td>
                <td><?= $p['gender'] ?></td>
                <td><?= $p['fis_code'] ?></td>
                <td><?= $p['licence_code'] ?></td>
                <td><?= $p['licence_type'] ?></td>
                <td><?= htmlspecialchars($p['club']) ?></td>
                <td><?= $p['country'] ?></td>
                <td><?= $p['dob'] ?></td>
                <td><?= $p['category'] ?></td>
                <td>
                    <a href="participant_edit.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
                    <a href="?delete=<?= $p['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this participant?')">Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>
</body>
</html>
