
<?php
session_start();
include 'includes/db.php';

$selected_event = $_GET['event_id'] ?? 0;
$filter_category = $_GET['category'] ?? 'all';

$events = $pdo->query("SELECT id, name FROM events ORDER BY date DESC")->fetchAll(PDO::FETCH_ASSOC);
$categories = $pdo->query("SELECT DISTINCT category FROM participants ORDER BY category")->fetchAll(PDO::FETCH_COLUMN);

$scores_query = "
SELECT
    r.id AS run_id,
    r.event_id,
    r.heat_number,
    r.status,
    ep.participant_id,
    p.bip,
    p.first_name,
    p.last_name,
    p.club,
    p.country,
    p.category,
    AVG(s.score_value) AS average_score
FROM runs r
JOIN event_participants ep ON r.event_participant_id = ep.id
JOIN participants p ON ep.participant_id = p.id
LEFT JOIN scores s ON r.id = s.run_id
WHERE r.event_id = ?
GROUP BY r.id
ORDER BY p.category, average_score DESC
";

$stmt = $pdo->prepare($scores_query);
$stmt->execute([$selected_event]);
$scores = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Group scores by category
$grouped_scores = [];
foreach ($scores as $score) {
    $cat = $score['category'] ?? 'Unknown';
    if (!isset($grouped_scores[$cat])) {
        $grouped_scores[$cat] = [];
    }
    $grouped_scores[$cat][] = $score;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Live Scoreboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .score-table { margin-bottom: 50px; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 8px rgba(0,0,0,0.1); }
        h3.category-title { margin-top: 40px; color: #1f4e79; }
        .header-row th { background: #f0f0f0; }
    </style>
</head>
<body class="p-4 bg-light">
<div class="container">
    <h2 class="mb-4">Live Scoreboard</h2>
    <form method="get" class="mb-4 row">
        <div class="col-md-4">
            <label>Choose Event:</label>
            <select name="event_id" class="form-select" onchange="this.form.submit()" required>
                <option value="">-- Select Event --</option>
                <?php foreach ($events as $ev): ?>
                    <option value="<?= $ev['id'] ?>" <?= $ev['id'] == $selected_event ? 'selected' : '' ?>>
                        <?= htmlspecialchars($ev['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label>Category:</label>
            <select name="category" class="form-select" onchange="this.form.submit()">
                <option value="all">-- All Categories --</option>
                <?php foreach ($categories as $cat): ?>
                    <option value="<?= htmlspecialchars($cat) ?>" <?= $cat == $filter_category ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </form>

    <?php if ($selected_event): ?>
        <?php foreach ($grouped_scores as $cat => $score_list): ?>
            <?php if ($filter_category !== 'all' && $cat !== $filter_category) continue; ?>
            <h3 class="category-title"><?= htmlspecialchars($cat) ?></h3>
            <div class="score-table table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="header-row">
                        <tr>
                            <th>#</th>
                            <th>BIP</th>
                            <th>Name</th>
                            <th>Club</th>
                            <th>Country</th>
                            <th>Heat</th>
                            <th>Score</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($score_list as $i => $row): ?>
                            <tr>
                                <td><?= $i+1 ?></td>
                                <td><?= $row['bip'] ?></td>
                                <td><?= $row['first_name'] . ' ' . $row['last_name'] ?></td>
                                <td><?= $row['club'] ?></td>
                                <td><?= $row['country'] ?></td>
                                <td><?= $row['heat_number'] ?></td>
                                <td><?= number_format($row['average_score'], 2) ?></td>
                                <td><?= $row['status'] ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
</body>
</html>
