
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Live Scoreboard</title>
  <meta http-equiv="refresh" content="10">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #111;
      color: #fff;
      font-family: 'Segoe UI', sans-serif;
    }
    .scoreboard-container {
      padding: 20px;
    }
    .scoreboard-title {
      font-size: 2rem;
      text-align: center;
      margin-bottom: 20px;
    }
    .table-dark th, .table-dark td {
      vertical-align: middle;
    }
  </style>
</head>
<body>
  <div class="scoreboard-container container">
    <div class="scoreboard-title">⛷ Live Scoreboard 🏂</div>
    <table class="table table-dark table-striped table-hover text-center">
      <thead>
        <tr>
          <th>#</th>
          <th>BIB</th>
          <th>Name</th>
          <th>Heat</th>
          <th>Run</th>
          <th>Average Score</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody id="scoreTableBody">
        <?php
        include 'includes/db.php';
        $stmt = $pdo->query("
          SELECT r.id, r.run_number, ep.heat_number,
                 p.bip, p.first_name, p.last_name,
                 AVG(s.score_value) AS avg_score
          FROM runs r
          JOIN event_participants ep ON r.event_participant_id = ep.id
          JOIN participants p ON ep.participant_id = p.id
          LEFT JOIN scores s ON s.run_id = r.id
          GROUP BY r.id
          ORDER BY ep.heat_number, p.bip, r.run_number
        ");
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $i = 1;
        foreach ($rows as $row):
        ?>
        <tr>
          <td><?= $i++ ?></td>
          <td><?= $row['bip'] ?></td>
          <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
          <td><?= $row['heat_number'] ?></td>
          <td><?= $row['run_number'] ?></td>
          <td><strong><?= is_null($row['avg_score']) ? '-' : number_format($row['avg_score'], 2) ?></strong></td>
          <td><?= $row['status'] ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
