<?php
include '../includes/auth.php';
include '../includes/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['judge_id'])) {
    $judge_id = intval($_POST['judge_id']);
    $is_head = isset($_POST['is_head']) ? 1 : 0;

    $stmt = $pdo->prepare("UPDATE judges SET is_head = ? WHERE id = ?");
    if ($stmt->execute([$is_head, $judge_id])) {
        $message = '<div class="alert alert-success">Judge updated successfully.</div>';
    } else {
        $message = '<div class="alert alert-danger">Failed to update judge.</div>';
    }
}

$judges = $pdo->query("SELECT * FROM judges ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Manage Judges</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Manage Judges</h2>
    <?php echo $message; ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Is Head Judge</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($judges as $judge): ?>
            <tr>
                <td><?= $judge['id'] ?></td>
                <td><?= htmlspecialchars($judge['name']) ?></td>
                <td><?= $judge['is_head'] ? 'Yes' : 'No' ?></td>
                <td>
                    <form method="post" class="d-flex align-items-center gap-2">
                        <input type="hidden" name="judge_id" value="<?= $judge['id'] ?>">
                        <input type="checkbox" name="is_head" <?= $judge['is_head'] ? 'checked' : '' ?>>
                        <button type="submit" class="btn btn-sm btn-primary">Update</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
