<?php
// Check actual StyleScore database structure for event_participants
try {
    require_once '../includes/db.php';
    echo "<h2>🔍 StyleScore Database Structure Analysis</h2>";
    
    // Check if event_participants table exists and its structure
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    
    if (in_array('event_participants', $tables)) {
        echo "<h3>✅ event_participants table structure:</h3>";
        $columns = $pdo->query("DESCRIBE event_participants")->fetchAll(PDO::FETCH_ASSOC);
        echo "<table border='1' style='border-collapse: collapse; margin-bottom: 20px;'>";
        echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        foreach ($columns as $col) {
            echo "<tr>";
            echo "<td><strong>{$col['Field']}</strong></td>";
            echo "<td>{$col['Type']}</td>";
            echo "<td>{$col['Null']}</td>";
            echo "<td>{$col['Key']}</td>";
            echo "<td>{$col['Default']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Show sample data
        $sample = $pdo->query("SELECT * FROM event_participants LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
        if ($sample) {
            echo "<h4>Sample Data:</h4>";
            echo "<pre>" . print_r($sample, true) . "</pre>";
        }
    } else {
        echo "<p style='color: red;'>❌ event_participants table not found</p>";
    }
    
    // Check other potential participant tables
    $participant_tables = ['participants', 'event_participant', 'competitors', 'athletes'];
    foreach ($participant_tables as $table) {
        if (in_array($table, $tables)) {
            echo "<h3>✅ $table table structure:</h3>";
            $columns = $pdo->query("DESCRIBE $table")->fetchAll(PDO::FETCH_ASSOC);
            echo "<table border='1' style='border-collapse: collapse; margin-bottom: 20px;'>";
            echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
            foreach ($columns as $col) {
                echo "<tr>";
                echo "<td><strong>{$col['Field']}</strong></td>";
                echo "<td>{$col['Type']}</td>";
                echo "<td>{$col['Null']}</td>";
                echo "<td>{$col['Key']}</td>";
                echo "<td>{$col['Default']}</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            // Show sample data
            $sample = $pdo->query("SELECT * FROM $table LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
            if ($sample) {
                echo "<h4>Sample Data:</h4>";
                echo "<pre>" . print_r($sample, true) . "</pre>";
            }
            echo "<hr>";
        }
    }
    
    // Check runs and scores tables
    echo "<h3>📊 Scoring Tables Structure:</h3>";
    $scoring_tables = ['runs', 'scores'];
    foreach ($scoring_tables as $table) {
        if (in_array($table, $tables)) {
            echo "<h4>$table:</h4>";
            $columns = $pdo->query("DESCRIBE $table")->fetchAll(PDO::FETCH_ASSOC);
            echo "<table border='1' style='border-collapse: collapse; margin-bottom: 15px;'>";
            echo "<tr style='background: #f0f0f0;'><th>Field</th><th>Type</th></tr>";
            foreach ($columns as $col) {
                echo "<tr><td><strong>{$col['Field']}</strong></td><td>{$col['Type']}</td></tr>";
            }
            echo "</table>";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
