<?php
session_start();
require '../includes/db.php';

if (!isset($_SESSION['user']) || $_SESSION['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
if (!isset($data['order']) || !is_array($data['order'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid payload']);
    exit;
}

$event_id = isset($data['event_id']) ? (int)$data['event_id'] : 0;
if (!$event_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing event ID']);
    exit;
}

try {
    $pdo->beginTransaction();
    foreach ($data['order'] as $index => $id) {
        $stmt = $pdo->prepare("UPDATE event_participants SET sort_order = ? WHERE id = ? AND event_id = ?");
        $stmt->execute([$index + 1, $id, $event_id]);
    }
    $pdo->commit();
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>