<?php
require '../includes/db.php';
require_once '../assets/tcpdf/tcpdf.php';

$event_id = $_GET['event_id'] ?? 0;
$heat_number = $_GET['heat_number'] ?? '';

$query = "
    SELECT ep.heat_number, p.bip, p.first_name, p.last_name, p.club, p.category
    FROM event_participants ep
    JOIN participants p ON ep.participant_id = p.id
    WHERE ep.event_id = ?
";
$params = [$event_id];

if ($heat_number !== '') {
    $query .= " AND ep.heat_number = ?";
    $params[] = $heat_number;
}

$query .= " ORDER BY ep.heat_number ASC, ep.sort_order ASC";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pdf = new TCPDF();
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 12);
$pdf->Cell(0, 10, "Heat Assignments", 0, 1, 'C');

$html = "<table border='1' cellpadding='4'><thead><tr>
<th>Heat</th><th>BIP</th><th>Name</th><th>Club</th><th>Category</th>
</tr></thead><tbody>";

foreach ($data as $row) {
    $html .= "<tr>
        <td>{$row['heat_number']}</td>
        <td>{$row['bip']}</td>
        <td>{$row['first_name']} {$row['last_name']}</td>
        <td>{$row['club']}</td>
        <td>{$row['category']}</td>
    </tr>";
}
$html .= "</tbody></table>";
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('heat_assignments.pdf', 'I');
?>